/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.Ime;
import com.teamdev.jxbrowser.browser.internal.NativeKeyboardListener;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.TakeFocusCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeCompositionCancelled;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeTextSpan;
import com.teamdev.jxbrowser.browser.internal.rpc.TakeFocus;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.Maybe;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.ui.HeadlessToolkits;
import com.teamdev.jxbrowser.internal.ui.ToolkitKey;
import com.teamdev.jxbrowser.internal.ui.ToolkitKeyCodes;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyLocation;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.ui.event.internal.rpc.NativeKeyEvent;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.ui.internal.KeyCodes;
import com.teamdev.jxbrowser.ui.internal.KeyEvents;
import com.teamdev.jxbrowser.view.swing.internal.BrowserComponent;
import com.teamdev.jxbrowser.view.swing.internal.ComponentLocator;
import com.teamdev.jxbrowser.view.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swing.internal.ImeRequestsHandler;
import com.teamdev.jxbrowser.view.swing.internal.ParentViewId;
import com.teamdev.jxbrowser.view.swing.internal.SwingCursorFactory;
import com.teamdev.jxbrowser.view.swing.internal.SwingKey;
import com.teamdev.jxbrowser.view.swing.internal.SwingKeyCodes;
import com.teamdev.jxbrowser.view.swing.internal.ToolkitConverters;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserDragContext;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragAndDropSupport;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class OffScreenRenderWidget
extends JComponent
implements BrowserComponent {
    private final KeyListener keyListener;
    private final NativeKeyboardListener nativeKeyboardListener;
    private final MouseListener mouseListener;
    private final FocusListener focusListener;
    private final ComponentListener resizeListener;
    private final WindowListener windowIconifiedListener;
    private final MouseWheelListener mouseWheelListener;
    private final ComponentListener windowMovedListener;
    private final HierarchyListener hierarchyListener;
    private final HierarchyBoundsListener hierarchyBoundsListener;
    private final BrowserWidget widget;
    private final DisplayWatcher displayWatcher;
    private final ToolkitKeyCodes<SwingKey> keyCodes;
    private final SwingCursorFactory cursorFactory;
    private final Maybe<DragAndDropSupport> dragAndDropSupport;
    private final Subscription browserClosed;
    private final Subscription compositionCancelled;
    private int lastKeyCode;
    private int lastKeyLocation;
    private ImeRequestsHandler imeRequestsHandler;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private boolean visible;
    private boolean isImeComposingText;

    OffScreenRenderWidget(BrowserWidget widget) {
        this.widget = widget;
        this.keyCodes = SwingKeyCodes.instance();
        this.focusListener = new FocusListener();
        this.resizeListener = new ResizeListener();
        this.keyListener = new KeyListener();
        this.nativeKeyboardListener = NativeKeyboardListener.create((BrowserWidget)widget, this::interceptNativeKeyEvent);
        this.mouseListener = new MouseListener();
        this.mouseWheelListener = new MouseWheelListener();
        this.windowMovedListener = new WindowMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        this.hierarchyListener = new HierarchyListenerImpl();
        this.hierarchyBoundsListener = new HierarchyBoundsListenerImpl();
        this.displayWatcher = DisplayWatcher.newInstance(this::onDisplayChanged);
        this.dragAndDropSupport = Maybe.of(() -> {
            if (!GraphicsEnvironment.isHeadless()) {
                return DragAndDropSupport.newInstance(this);
            }
            return null;
        });
        this.cursorFactory = new SwingCursorFactory();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setIgnoreRepaint(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableInputMethods(true);
        this.enableEvents(2088L);
        this.browserClosed = widget.browser().on(BrowserClosed.class, event -> this.close());
        this.compositionCancelled = widget.ime().on(ImeCompositionCancelled.class, event -> this.getInputContext().endComposition());
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent event) {
        super.processInputMethodEvent(event);
        if (!event.isConsumed() && event.getID() == 1100) {
            AttributedCharacterIterator it = event.getText();
            if (it != null) {
                ArrayList<ImeTextSpan> imeTextSpans = new ArrayList<ImeTextSpan>();
                StringBuilder stringBuilder = new StringBuilder();
                char c = it.first();
                while (c != '\uffff') {
                    stringBuilder.append(c);
                    c = it.next();
                }
                String text = stringBuilder.toString();
                imeTextSpans.add(Ime.createTextSpan((int)0, (int)text.length(), (boolean)true));
                if (event.getCommittedCharacterCount() == 0) {
                    this.widget().ime().setComposition(text, imeTextSpans);
                    this.isImeComposingText = true;
                } else {
                    if (!this.widget().isClosed()) {
                        this.widget().ime().commitText(text);
                    }
                    this.isImeComposingText = false;
                }
            }
            event.consume();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.imeRequestsHandler == null) {
            this.imeRequestsHandler = new ImeRequestsHandler(this);
        }
        return this.imeRequestsHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this.hierarchyListener);
        this.addHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.showRenderWidget();
    }

    @Override
    public void removeNotify() {
        this.hideRenderWidget();
        this.removeHierarchyListener(this.hierarchyListener);
        this.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
        super.removeNotify();
    }

    boolean isShown() {
        return this.visible;
    }

    void close() {
        this.hideRenderWidget();
        this.browserClosed.unsubscribe();
        this.compositionCancelled.unsubscribe();
    }

    public final BrowserWidget widget() {
        return this.widget;
    }

    void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        this.addKeyboardListener();
        this.addMouseListeners();
        this.addWindowListeners();
        this.addFocusListener(this.focusListener);
        this.addComponentListener(this.resizeListener);
        ParentViewId.from(this).ifPresent(arg_0 -> ((BrowserWidget)this.widget).assignHostWindow(arg_0));
        this.widget.show();
        this.notifyBoundsUpdated();
        this.cursorChanged = this.widget.on(CursorChanged.class, event -> {
            try {
                Cursor cursor = (Cursor)this.cursorFactory.newCursor((CursorChanged)event);
                SwingUtilities.invokeLater(() -> this.setCursor(cursor));
            }
            catch (Exception e) {
                Logger.error((String)"Failed to change cursor", (Throwable)e);
            }
        });
        this.tooltipChanged = this.widget.on(TooltipChanged.class, event -> SwingUtilities.invokeLater(() -> {
            String text = event.getTooltipText();
            if (text.isEmpty()) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(this.textToHtml(text));
            }
        }));
        this.widget.set(TakeFocusCallback.class, (BrowserWidgetCallback)((TakeFocusCallback)params -> {
            SwingUtilities.invokeLater(() -> {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (params.getFocusNextComponent()) {
                    focusManager.focusNextComponent();
                } else {
                    focusManager.focusPreviousComponent();
                }
            });
            return TakeFocus.Response.newBuilder().setTake(Protobuf.empty()).build();
        }));
        this.widget.browser().dragAndDrop().ifEnabled(() -> this.dragAndDropSupport.get().ifPresent(DragAndDropSupport::enable));
        this.visible = true;
    }

    private String textToHtml(String tooltip) {
        return String.format("<html>%s</html>", tooltip.replace("\n", "<br>"));
    }

    private void interceptNativeKeyEvent(NativeKeyEvent keyEvent) {
        SwingUtilities.invokeLater(() -> this.widget.dispatch(keyEvent));
    }

    void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.cursorChanged.unsubscribe();
        this.tooltipChanged.unsubscribe();
        this.widget.remove(TakeFocusCallback.class);
        if (this.isEmbeddedInTabbedPane() && this.isFocusOwner()) {
            this.widget.unfocus();
        }
        this.dragAndDropSupport.get().ifPresent(DragAndDropSupport::disable);
        this.removeKeyboardListener();
        if (!this.widget.isClosed()) {
            this.widget.hide();
        }
        this.removeFocusListener(this.focusListener);
        this.removeComponentListener(this.resizeListener);
        this.removeWindowListeners();
        this.removeMouseListeners();
        this.visible = false;
    }

    private boolean isEmbeddedInTabbedPane() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JTabbedPane)) continue;
            return true;
        }
        return false;
    }

    private void addWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addComponentListener(this.windowMovedListener);
            window.addWindowListener(this.windowIconifiedListener);
            this.displayWatcher.attach(window);
        }
    }

    private void removeWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.windowMovedListener);
            window.removeWindowListener(this.windowIconifiedListener);
            this.displayWatcher.detach();
        }
    }

    private void addKeyboardListener() {
        boolean canUseNativeInput;
        boolean bl = canUseNativeInput = SystemProperties.hasProperty((String)"jxbrowser.native.keyboard.input.enabled") && !HeadlessToolkits.isHeadlessToolkit();
        if (canUseNativeInput) {
            Optional<Long> viewId = ParentViewId.from(this);
            if (viewId.isPresent()) {
                this.nativeKeyboardListener.start(viewId.get().longValue(), this.hasFocus());
            } else {
                this.addKeyListener(this.keyListener);
                Logger.warn((String)"Failed to find the native window handle. Falling back to Java keyboard input.");
            }
        } else {
            this.addKeyListener(this.keyListener);
        }
    }

    private void removeKeyboardListener() {
        if (this.nativeKeyboardListener.isActive()) {
            this.nativeKeyboardListener.stop();
        } else {
            this.removeKeyListener(this.keyListener);
        }
    }

    private void removeMouseListeners() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseWheelListener(this.mouseWheelListener);
    }

    private void addMouseListeners() {
        this.addMouseListener(this.mouseListener);
        this.addMouseWheelListener(this.mouseWheelListener);
    }

    @Override
    public synchronized void addMouseListener(java.awt.event.MouseListener l) {
        if (!Arrays.asList(this.getMouseListeners()).contains(l)) {
            super.addMouseListener(l);
        }
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (!Arrays.asList(this.getMouseMotionListeners()).contains(l)) {
            super.addMouseMotionListener(l);
        }
    }

    @Override
    public synchronized void addMouseWheelListener(java.awt.event.MouseWheelListener l) {
        if (!Arrays.asList(this.getMouseWheelListeners()).contains(l)) {
            super.addMouseWheelListener(l);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.addMouseListeners();
        } else {
            this.removeMouseListeners();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.notifyBoundsUpdated();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.widget.show();
        } else {
            this.widget.hide();
        }
    }

    private void notifyBoundsUpdated() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        java.awt.Point locationOnScreen = this.getLocationOnScreen();
        if (bounds.width < 0 || bounds.height < 0) {
            return;
        }
        bounds.setLocation(ComponentLocator.locationInWindow(this));
        Rect boundsInWindow = Geometry.newRect((double)bounds.x, (double)bounds.y, (double)bounds.width, (double)bounds.height);
        Rect boundsInScreen = Geometry.newRect((double)locationOnScreen.x, (double)locationOnScreen.y, (double)bounds.width, (double)bounds.height);
        this.widget.bounds(boundsInWindow, boundsInScreen);
    }

    private void onDisplayChanged(Display display) {
        this.widget.displayId(display.id());
    }

    private Point screenPoint(MouseEvent e) {
        java.awt.Point location = ComponentLocator.locationOnScreen(e.getComponent());
        int x = e.getX();
        int y = e.getY();
        int globalX = location.x + x;
        int globalY = location.y + y;
        Point point = Geometry.newPoint((double)globalX, (double)globalY);
        return point;
    }

    private Point localPoint(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point point = Geometry.newPoint((double)x, (double)y);
        return point;
    }

    private void dispatchMouseDragged(MouseEvent e) {
        this.widget.dispatch(MouseDragged.newBuilder((Point)this.localPoint(e)).locationOnScreen(this.screenPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
    }

    private static KeyModifiers keyModifiers(InputEvent e) {
        return KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e)).build();
    }

    private static KeyModifiers keyModifiers(MouseEvent e) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e));
        if (SwingUtilities.isRightMouseButton(e)) {
            builder.metaDown(false);
        }
        return builder.build();
    }

    private static KeyLocation keyLocation(KeyEvent e) {
        return OffScreenRenderWidget.keyLocation(e.getKeyLocation());
    }

    private static KeyLocation keyLocation(int location) {
        if (location == 4) {
            return KeyLocation.NUMERIC_KEYPAD;
        }
        if (location == 2) {
            return KeyLocation.LEFT;
        }
        if (location == 3) {
            return KeyLocation.RIGHT;
        }
        return KeyLocation.STANDARD;
    }

    private static MouseModifiers mouseModifiers(MouseEvent e) {
        int modifiersEx = e.getModifiersEx();
        return MouseModifiers.newBuilder().primaryButtonDown((modifiersEx & 0x400) == 1024).middleButtonDown((modifiersEx & 0x800) == 2048).secondaryButtonDown((modifiersEx & 0x1000) == 4096).build();
    }

    private void dispatchMouseMoved(MouseEvent e) {
        this.widget.dispatch(MouseMoved.newBuilder((Point)this.localPoint(e)).locationOnScreen(this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
    }

    static MouseButton mouseButton(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            return MouseButton.PRIMARY;
        }
        if (SwingUtilities.isMiddleMouseButton(event)) {
            return MouseButton.MIDDLE;
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            return MouseButton.SECONDARY;
        }
        if (event.getButton() == 0) {
            return MouseButton.NO_BUTTON;
        }
        return MouseButton.MOUSE_BUTTON_UNSPECIFIED;
    }

    private static boolean isShiftDown(InputEvent event) {
        return event.isShiftDown();
    }

    private static boolean isControlDown(InputEvent event) {
        if (OffScreenRenderWidget.isAltGraphDown(event)) {
            return false;
        }
        return event.isControlDown();
    }

    private static boolean isMetaDown(InputEvent event) {
        return event.isMetaDown();
    }

    private static boolean isAltDown(InputEvent event) {
        if (OffScreenRenderWidget.isAltGraphDown(event)) {
            return false;
        }
        return event.isAltDown();
    }

    private static boolean isAltGraphDown(InputEvent event) {
        return event.isAltGraphDown();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 502) {
            this.dragAndDropSupport.get().ifPresent(dnd -> {
                boolean wasShortDrag;
                BrowserDragContext context = dnd.context();
                boolean bl = wasShortDrag = context.isBrowserDragHappening() && !context.isSwingDragHappening();
                if (wasShortDrag) {
                    Point location = ToolkitConverters.toProtoPoint(e.getPoint());
                    Point emptyPoint = Point.empty();
                    context.browserDragOperation().ifPresent(operation -> this.widget.drop(operation.dropData(), emptyPoint, location));
                    this.widget.dragEnd(emptyPoint, location, DragOperation.OPERATION_NONE);
                    dnd.resetDrag();
                }
            });
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getID() == 503) {
            super.processMouseMotionEvent(e);
            this.dispatchMouseMoved(e);
            return;
        }
        if (e.getID() == 506) {
            if (this.isBrowserDragHappening()) {
                super.processMouseMotionEvent(e);
                return;
            }
            this.dispatchMouseDragged(e);
        }
    }

    private boolean isBrowserDragHappening() {
        return this.dragAndDropSupport.get().map(dnd -> dnd.context().isBrowserDragHappening()).orElse(false);
    }

    private void requestFocusIfNecessary() {
        if (!this.hasFocus()) {
            this.requestFocus();
        }
    }

    @Override
    public void enableDragAndDrop() {
        this.widget.browser().dragAndDrop().ifEnabled(() -> this.dragAndDropSupport.get().ifPresent(DragAndDropSupport::enable));
    }

    @Override
    public void disableDragAndDrop() {
        this.widget.browser().dragAndDrop().ifEnabled(() -> this.dragAndDropSupport.get().ifPresent(DragAndDropSupport::disable));
    }

    public Rect translateRect(Rect srcRect) {
        Rect result = srcRect;
        Container topLevelWindow = SwingUtilities.getWindowAncestor(this);
        if (topLevelWindow instanceof RootPaneContainer) {
            topLevelWindow = ((RootPaneContainer)((Object)topLevelWindow)).getContentPane();
        }
        if (topLevelWindow != null) {
            int posX = (int)this.getLocationOnScreen().getX();
            int posY = (int)this.getLocationOnScreen().getY();
            result = Rect.of((int)(result.x() + posX), (int)(result.y() + posY), (int)result.width(), (int)result.height());
        }
        return result;
    }

    @Override
    public void setEnabledExternalDrag(boolean enabled) {
        this.dragAndDropSupport.ifPresent(dnd -> this.widget.browser().dragAndDrop().ifEnabled(() -> dnd.context().setEnabledExternalDrag(enabled)));
    }

    private void cancelImeComposition() {
        this.getInputContext().endComposition();
        this.widget.ime().cancelComposition();
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (OffScreenRenderWidget.this.isEnabled()) {
                OffScreenRenderWidget.this.widget.focus(ToolkitConverters.toProtoCause(e.getCause()));
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (OffScreenRenderWidget.this.isEnabled()) {
                OffScreenRenderWidget.this.widget.unfocus();
            }
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        private KeyCode keyCode(KeyEvent event) {
            KeyCode keyCode = OffScreenRenderWidget.this.keyCodes.toKeyCode((ToolkitKey)SwingKey.from(event));
            int extendedKeyCodeForChar = KeyEvent.getExtendedKeyCodeForChar(event.getKeyChar());
            KeyCode extendedKeyCode = OffScreenRenderWidget.this.keyCodes.toKeyCode((ToolkitKey)SwingKey.of(extendedKeyCodeForChar, event.getKeyLocation()));
            if (this.isAltGrOrCtrlAlt(event) && extendedKeyCode != KeyCode.KEY_CODE_UNSPECIFIED && keyCode == KeyCode.KEY_CODE_UNSPECIFIED) {
                return extendedKeyCode;
            }
            return keyCode;
        }

        private boolean isAltGrOrCtrlAlt(KeyEvent event) {
            return OffScreenRenderWidget.isAltGraphDown(event) || OffScreenRenderWidget.isControlDown(event) && OffScreenRenderWidget.isAltDown(event);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int javaKeyCode = OffScreenRenderWidget.this.lastKeyCode != 0 ? OffScreenRenderWidget.this.lastKeyCode : e.getKeyCode();
            int keyLocation = OffScreenRenderWidget.this.lastKeyLocation != 0 ? OffScreenRenderWidget.this.lastKeyLocation : e.getKeyLocation();
            KeyCode keyCode = OffScreenRenderWidget.this.keyCodes.toKeyCode((ToolkitKey)SwingKey.of(javaKeyCode, keyLocation));
            KeyModifiers modifiers = OffScreenRenderWidget.keyModifiers(e);
            char character = e.getKeyChar();
            if (Environment.isMac() && KeyEvents.isMacAccessKey((KeyCode)keyCode, (KeyModifiers)modifiers)) {
                character = KeyCodes.toAlphabeticChar((KeyCode)keyCode);
            }
            OffScreenRenderWidget.this.widget.dispatch(KeyTyped.newBuilder((KeyCode)keyCode).keyChar(character).keyModifiers(modifiers).keyLocation(OffScreenRenderWidget.keyLocation(keyLocation)).build());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.suppressTraversalKey(e);
            KeyCode keyCode = this.keyCode(e);
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = e.getKeyCode();
            OffScreenRenderWidget.this.lastKeyLocation = e.getKeyLocation();
            KeyPressed.Builder builder = KeyPressed.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).keyLocation(OffScreenRenderWidget.keyLocation(e));
            OffScreenRenderWidget.this.widget.dispatch(builder.build());
        }

        private void suppressTraversalKey(KeyEvent event) {
            if (event.getKeyChar() == '\t') {
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyCode keyCode = this.keyCode(e);
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = 0;
            OffScreenRenderWidget.this.widget.dispatch(KeyReleased.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).keyLocation(OffScreenRenderWidget.keyLocation(e)).build());
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseEntered.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseExited.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            if (OffScreenRenderWidget.this.isImeComposingText) {
                OffScreenRenderWidget.this.cancelImeComposition();
            }
            OffScreenRenderWidget.this.requestFocusIfNecessary();
            OffScreenRenderWidget.this.widget.dispatch(MousePressed.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            OffScreenRenderWidget.this.widget.dispatch(MouseReleased.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).button(OffScreenRenderWidget.mouseButton(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.mouseModifiers(e)).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).build());
        }
    }

    private class MouseWheelListener
    extends MouseAdapter {
        private MouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            int directionFix = -1;
            ScrollType scrollType = ScrollType.forNumber((int)e.getScrollType());
            if (scrollType == null) {
                scrollType = ScrollType.SCROLL_TYPE_UNSPECIFIED;
            }
            float pointsPerUnit = Environment.isMac() ? 10.0f : 33.333332f;
            float delta = (float)e.getUnitsToScroll() * pointsPerUnit * (float)directionFix;
            float deltaX = e.isShiftDown() ? delta : 0.0f;
            float deltaY = !e.isShiftDown() ? delta : 0.0f;
            OffScreenRenderWidget.this.widget.dispatch(MouseWheel.newBuilder((Point)OffScreenRenderWidget.this.localPoint(e)).locationOnScreen(OffScreenRenderWidget.this.screenPoint(e)).deltaX(deltaX).deltaY(deltaY).keyModifiers(OffScreenRenderWidget.keyModifiers(e)).scrollType(scrollType).build());
        }
    }

    private class WindowMovedListener
    extends ComponentAdapter {
        private WindowMovedListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            OffScreenRenderWidget.this.notifyBoundsUpdated();
        }
    }

    private class WindowIconifiedListener
    extends WindowAdapter {
        private WindowIconifiedListener() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            OffScreenRenderWidget.this.widget.minimize();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            OffScreenRenderWidget.this.widget.restore();
        }
    }

    private class HierarchyListenerImpl
    implements HierarchyListener {
        private HierarchyListenerImpl() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 4L) {
                if (OffScreenRenderWidget.this.isShowing()) {
                    OffScreenRenderWidget.this.showRenderWidget();
                } else {
                    OffScreenRenderWidget.this.hideRenderWidget();
                }
            }
        }
    }

    private class HierarchyBoundsListenerImpl
    implements HierarchyBoundsListener {
        private HierarchyBoundsListenerImpl() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }
}

