/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.graphics;

import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.graphics.BitmapImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public final class CursorImage
extends BitmapImage<BufferedImage> {
    public static BufferedImage toToolkit(Bitmap bitmap) {
        return (BufferedImage)new CursorImage(bitmap).toolkitImage();
    }

    private CursorImage(Bitmap bitmap) {
        super(bitmap);
    }

    protected BufferedImage createImage() {
        BufferedImage cursorImage = com.teamdev.jxbrowser.view.swing.graphics.BitmapImage.toToolkit(this.bitmap());
        return this.fitToPreferredSize(cursorImage);
    }

    private Size preferredSize() {
        Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(this.bitmapWidth(), this.bitmapHeight());
        return Size.of((int)((int)bestCursorSize.getWidth()), (int)((int)bestCursorSize.getHeight()));
    }

    private BufferedImage fitToPreferredSize(BufferedImage cursorImage) {
        int preferredWidth = this.preferredSize().width();
        int preferredHeight = this.preferredSize().height();
        if (this.bitmapWidth() >= preferredWidth || this.bitmapHeight() >= preferredHeight) {
            return cursorImage;
        }
        BufferedImage result = new BufferedImage(preferredWidth, preferredHeight, 2);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(cursorImage, 0, 0, this.bitmapWidth(), this.bitmapHeight(), null);
        return result;
    }

    private int bitmapWidth() {
        return this.bitmap().size().width();
    }

    private int bitmapHeight() {
        return this.bitmap().size().height();
    }
}

