/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ContextMenuItem;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ShowContextMenu;
import com.teamdev.jxbrowser.media.MediaType;
import com.teamdev.jxbrowser.menu.SpellCheckMenu;
import com.teamdev.jxbrowser.menu.internal.rpc.ContextMenuContentType;
import com.teamdev.jxbrowser.ui.Point;
import java.util.List;
import java.util.function.Consumer;

public interface ShowContextMenuCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<ShowContextMenu.Response> {
        public Action(Consumer<ShowContextMenu.Response> consumer) {
            super(consumer);
        }

        public void select(com.teamdev.jxbrowser.menu.ContextMenuItem item) {
            Preconditions.checkNotNull(item);
            this.send(ShowContextMenu.Response.newBuilder().setSelectContextMenuItem((ContextMenuItem)item).build());
        }

        public void close() {
            this.send(ShowContextMenu.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        default public Browser browser() {
            BrowserId id = ShowContextMenu.Request.cast(this).getBrowserId();
            return BrowserImpl.of(id);
        }

        default public Point location() {
            return ShowContextMenu.Request.cast(this).getLocation();
        }

        default public String linkUrl() {
            return ShowContextMenu.Request.cast(this).getLinkUrl();
        }

        default public String linkText() {
            return ShowContextMenu.Request.cast(this).getLinkText();
        }

        default public String srcUrl() {
            return ShowContextMenu.Request.cast(this).getSrcUrl();
        }

        default public String pageUrl() {
            return ShowContextMenu.Request.cast(this).getPageUrl();
        }

        default public String frameUrl() {
            return ShowContextMenu.Request.cast(this).getFrameUrl();
        }

        default public boolean isMainFrame() {
            return ShowContextMenu.Request.cast(this).getIsMainFrame();
        }

        default public String selectedText() {
            return ShowContextMenu.Request.cast(this).getSelectedText();
        }

        default public String frameCharset() {
            return ShowContextMenu.Request.cast(this).getFrameCharset();
        }

        default public MediaType mediaType() {
            return ShowContextMenu.Request.cast(this).getMediaType();
        }

        @Immutable
        default public List<com.teamdev.jxbrowser.menu.ContextMenuItem> extensionMenuItems() {
            return ImmutableList.copyOf(ShowContextMenu.Request.cast(this).getExtensionMenuItemList());
        }

        default public SpellCheckMenu spellCheckMenu() {
            return ShowContextMenu.Request.cast(this).getSpellCheckMenu();
        }

        default public List<ContextMenuContentType> contentType() {
            return ShowContextMenu.Request.cast(this).getContentTypeList();
        }
    }
}

