/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.callback.internal;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.callback.BrowserAsyncCallback;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.common.collect.ImmutableList;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ShowPopup;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import java.util.List;
import java.util.function.Consumer;

public interface ShowSuggestionsCallback
extends BrowserAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<ShowPopup.Response> {
        public Action(Consumer<ShowPopup.Response> consumer) {
            super(consumer);
        }

        public void accept(Suggestion suggestion) {
            Preconditions.checkNotNull(suggestion);
            this.send(ShowPopup.Response.newBuilder().setAccept(suggestion).build());
        }

        public void cancel() {
            this.send(ShowPopup.Response.newBuilder().setCancel(Protobuf.empty()).build());
        }
    }

    public static interface Params {
        @Immutable
        default public List<Suggestion> suggestions() {
            return ImmutableList.copyOf(((ShowPopup.Request)this).getSuggestions().getSuggestionList());
        }

        default public Point location() {
            return ((ShowPopup.Request)this).getLocation();
        }

        default public SuggestionsPopupType popupType() {
            return ((ShowPopup.Request)this).getPopupType();
        }

        default public double scaleFactor() {
            return ((ShowPopup.Request)this).getScaleFactor();
        }
    }
}

