/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.browser.internal;

import com.teamdev.jxbrowser.browser.event.internal.ImeEvent;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeCaretRectChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeCommitTextRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeSetCompositionRequest;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeStub;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeTextSpan;
import com.teamdev.jxbrowser.event.Observable;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.internal.rpc.Color;
import java.util.List;

public final class Ime
extends CloseableImpl
implements Observable<ImeEvent> {
    private static final com.teamdev.jxbrowser.ui.Color BACKGROUND_COLOR = com.teamdev.jxbrowser.ui.Color.rgba(1.0f, 0.0f, 0.0f, 0.0f);
    private static final com.teamdev.jxbrowser.ui.Color FOREGROUND_COLOR = com.teamdev.jxbrowser.ui.Color.rgba(0.0f, 0.0f, 0.0f, 1.0f);
    private final BrowserId browserId;
    private final BrowserWidget widget;
    private final ServiceConnectionImpl<ImeStub> rpc;
    private Rect caretPosition = Rect.empty();
    private String composedText = "";
    private boolean skipNextCommit = false;

    public static ImeTextSpan createTextSpan(int start, int end, boolean highlight) {
        Color foreground = Color.cast(FOREGROUND_COLOR);
        Color background = Color.cast(BACKGROUND_COLOR);
        return ImeTextSpan.newBuilder().setStart(start).setEnd(end).setForegroundColor(foreground).setBackgroundColor(background).setThick(!highlight).build();
    }

    public Ime(BrowserWidget widget) {
        this.widget = widget;
        this.browserId = widget.browser().id();
        Connection connection = widget.browser().engine().connection();
        this.rpc = new ServiceConnectionImpl<ImeStub>(this.browserId, connection, ImeStub::new);
        this.on(ImeCaretRectChanged.class, event -> {
            this.caretPosition = event.getNewRect();
        });
    }

    public Rect getCaretPosition() {
        return this.caretPosition;
    }

    @Override
    public <E extends ImeEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    public void cancelComposition() {
        if (!this.composedText.isEmpty()) {
            this.commitText(this.composedText);
            this.skipNextCommit = true;
        } else {
            this.rpc.invokeAsync(this.rpc.stub()::cancelComposition, this.browserId);
        }
    }

    public void setComposition(String text, List<ImeTextSpan> textSpans) {
        this.composedText = text;
        this.skipNextCommit = false;
        ImeSetCompositionRequest request = ImeSetCompositionRequest.newBuilder().setBrowserId(this.browserId).setText(text).addAllTextSpans(textSpans).setStart(text.length()).setEnd(text.length()).build();
        this.rpc.invokeAsync(this.rpc.stub()::setComposition, request);
    }

    public void commitText(String text) {
        if (!this.skipNextCommit) {
            ImeCommitTextRequest request = ImeCommitTextRequest.newBuilder().setBrowserId(this.browserId).setText(text).build();
            this.rpc.invokeAsync(this.rpc.stub()::commitText, request);
            this.composedText = "";
        } else {
            this.skipNextCommit = false;
        }
    }

    public String getSelectedText() {
        return this.widget.browser().mainFrame().map(Frame::selectionAsText).orElse("");
    }

    @Override
    public void close() {
        this.rpc.close();
    }
}

