/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.cast.internal;

import com.teamdev.jxbrowser.cast.MediaReceiver;
import com.teamdev.jxbrowser.cast.MediaReceiverState;
import com.teamdev.jxbrowser.cast.MediaSource;
import com.teamdev.jxbrowser.cast.PresentationRequest;
import com.teamdev.jxbrowser.cast.ReceiverDisconnectedException;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverDetailsRequest;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverDisconnected;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverInfo;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverStateResult;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaReceiverStub;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaSourceRequest;
import com.teamdev.jxbrowser.cast.internal.rpc.MediaSourceResponse;
import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.MediaReceiverId;
import com.teamdev.jxbrowser.internal.rpc.Protobuf;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.stream.Interceptor;
import com.teamdev.jxbrowser.profile.Profile;
import com.teamdev.jxbrowser.profile.internal.ProfileImpl;

public final class MediaReceiverImpl
extends CloseableImpl
implements MediaReceiver {
    private final MediaReceiverInfo receiverInfo;
    private final ServiceConnectionImpl<MediaReceiverStub> rpc;
    private final ProfileImpl profile;

    public MediaReceiverImpl(MediaReceiverInfo receiverInfo, ProfileImpl profile) {
        Preconditions.checkNotNull(receiverInfo);
        Preconditions.checkNotNull(profile);
        this.receiverInfo = receiverInfo;
        this.rpc = new ServiceConnectionImpl<MediaReceiverStub>(receiverInfo.getId(), profile.engine().connection(), MediaReceiverStub::new);
        this.profile = profile;
        this.rpc.setEventInterceptor(MediaReceiverDisconnected.class, event -> {
            this.rpc.dispatch(event);
            profile.mediaCasting().mediaReceivers().removeReceiver(event.getReceiverId());
            return Interceptor.Action.CANCEL;
        });
    }

    public MediaReceiverId id() {
        return this.receiverInfo.getId();
    }

    @Override
    public String name() {
        this.checkNotClosed();
        return this.receiverInfo.getFriendlyName();
    }

    @Override
    public MediaReceiverState state() {
        this.checkNotClosed();
        return ((MediaReceiverStateResult)this.rpc.invoke(this.rpc.stub()::getState, this.receiverDetailsRequest())).getState();
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    @Override
    public boolean supports(MediaSource mediaSource) {
        MediaSourceRequest request;
        this.checkNotClosed();
        Preconditions.checkNotNull(mediaSource);
        MediaSourceRequest.Builder requestBuilder = this.supportMediaSourceRequestBuilder();
        if (mediaSource instanceof PresentationRequest) {
            PresentationRequest presentationRequest = (PresentationRequest)mediaSource;
            request = requestBuilder.setPresentationRequest(com.teamdev.jxbrowser.cast.internal.rpc.PresentationRequest.cast(presentationRequest)).build();
        } else if (mediaSource.equals(MediaSource.browser())) {
            request = requestBuilder.setBrowser(Protobuf.empty()).build();
        } else if (mediaSource.equals(MediaSource.screen())) {
            request = requestBuilder.setScreen(Protobuf.empty()).build();
        } else {
            return false;
        }
        return this.supportsMediaSource(request);
    }

    private boolean supportsMediaSource(MediaSourceRequest request) {
        MediaSourceResponse response = (MediaSourceResponse)this.rpc.invoke(this.rpc.stub()::supportsMediaSource, request);
        String errorMessage = response.getErrorMessage();
        if (!errorMessage.isEmpty()) {
            throw new ReceiverDisconnectedException(errorMessage);
        }
        return response.getValue();
    }

    private MediaSourceRequest.Builder supportMediaSourceRequestBuilder() {
        return MediaSourceRequest.newBuilder().setReceiverId(this.id()).setProfileId(this.profile.id());
    }

    private MediaReceiverDetailsRequest receiverDetailsRequest() {
        return MediaReceiverDetailsRequest.newBuilder().setReceiverId(this.receiverInfo.getId()).setProfileId(this.profile.id()).build();
    }

    @Override
    public <E extends com.teamdev.jxbrowser.cast.event.MediaReceiverDisconnected> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

