/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.dom.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.dom.OptionElement;
import com.teamdev.jxbrowser.dom.SelectElement;
import com.teamdev.jxbrowser.dom.internal.FormControlElementImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.GetOptionsRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.IsMultipleRequest;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfoList;
import com.teamdev.jxbrowser.dom.internal.rpc.SelectElementStub;
import com.teamdev.jxbrowser.dom.internal.rpc.SetMultipleRequest;
import com.teamdev.jxbrowser.frame.internal.DomContext;
import com.teamdev.jxbrowser.internal.rpc.ServiceConnectionImpl;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import java.util.Collections;
import java.util.List;

public final class SelectElementImpl
extends FormControlElementImpl
implements SelectElement {
    private final ServiceConnectionImpl<SelectElementStub> rpc;

    public static SelectElementImpl newInstance(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        return new SelectElementImpl(connection, domContext, nodeInfo);
    }

    private SelectElementImpl(Connection connection, DomContext domContext, NodeInfo nodeInfo) {
        super(connection, domContext, nodeInfo);
        this.rpc = new ServiceConnectionImpl<SelectElementStub>(nodeInfo, connection, SelectElementStub::new);
    }

    @Override
    public List<OptionElement> options() {
        this.checkNotClosed();
        GetOptionsRequest request = GetOptionsRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        NodeInfoList response = (NodeInfoList)this.rpc.invoke(this.rpc.stub()::getOptions, request);
        return Collections.unmodifiableList(this.domContext().toNodes(response.getNodeInfoList(), OptionElement.class));
    }

    @Override
    public boolean isMultiple() {
        this.checkNotClosed();
        IsMultipleRequest request = IsMultipleRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isMultiple, request)).getValue();
    }

    @Override
    public void multiple(boolean multiple) {
        this.checkNotClosed();
        SetMultipleRequest request = SetMultipleRequest.newBuilder().setFrameId(this.frameId()).setNodeId(this.nodeId()).setMultiple(multiple).build();
        this.rpc.invoke(this.rpc.stub()::setMultiple, request);
    }
}

