/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.os.Environment;

public enum JniLibraryName {
    TOOLKIT("toolkit"),
    IPC("ipc"),
    AWT_TOOLKIT("awt_toolkit");

    private final String value;

    private JniLibraryName(String value) {
        this.value = value;
    }

    public String toPlatform() {
        if (Environment.isWindows()) {
            if (Environment.is32Bit()) {
                return this.value + "32.dll";
            }
            if (Environment.isArm()) {
                return this.value + "_arm64.dll";
            }
            return this.value + "64.dll";
        }
        if (Environment.isMac()) {
            return "lib" + this.value + ".dylib";
        }
        if (Environment.isLinux()) {
            return "lib" + this.value + ".so";
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public String toString() {
        return this.value;
    }
}

