/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal;

import com.teamdev.jxbrowser.internal.BinariesListing;
import com.teamdev.jxbrowser.internal.BinaryVerifier;
import com.teamdev.jxbrowser.internal.Files;
import com.teamdev.jxbrowser.internal.xz.JavaResourceExtractor;
import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;

public class NativeBinaryVerifier
implements BinaryVerifier {
    private static final int SUCCESS = 0;
    private static final int VERIFICATION_FAILED = 1;

    @Override
    public boolean verify(Path chromiumDir, List<BinariesListing> listings) {
        Path verifier = chromiumDir.resolve("verifier.exe");
        for (BinariesListing listing : listings) {
            Logger.debug("Using {0} listing...", listing.name());
            Path propertyFile = chromiumDir.resolve(listing.propertyFileName());
            try {
                try (FileOutputStream stream = new FileOutputStream(propertyFile.toFile());){
                    listing.asProperties().store(stream, null);
                }
                JavaResourceExtractor extractor = new JavaResourceExtractor();
                extractor.extract("verifier.exe", verifier);
                String[] args = new String[]{verifier.toString(), listing.propertyFileName()};
                Process process = Runtime.getRuntime().exec(args);
                this.startLogging(process);
                int exitCode = process.waitFor();
                if (exitCode == 0) {
                    Logger.debug("Checking binaries integrity... [OK]");
                    boolean bl = true;
                    return bl;
                }
                if (exitCode == 1) continue;
                throw new IllegalStateException("Verification failed with exit code: " + exitCode);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                Files.deleteFile(propertyFile);
                Files.deleteFile(verifier);
            }
        }
        Logger.debug("Checking binaries integrity... [FAIL]");
        return false;
    }

    private void startLogging(Process process) {
        this.startLogging("out", process.getInputStream(), Logger::debug);
        this.startLogging("error", process.getErrorStream(), Logger::debug);
    }

    private void startLogging(String logName, InputStream inputStream, Consumer<String> logger) {
        Thread loggerThread = new Thread(() -> {
            try {
                String line;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_16LE);
                BufferedReader input = new BufferedReader(inputStreamReader);
                while ((line = input.readLine()) != null) {
                    logger.accept(line);
                }
                input.close();
            }
            catch (IOException e) {
                Logger.error("Failed to log process output.", e);
            }
        }, String.format("Logger (%s)", logName));
        loggerThread.setDaemon(true);
        loggerThread.start();
    }
}

