/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.net.ContentType;
import com.teamdev.jxbrowser.net.UploadData;
import java.nio.charset.StandardCharsets;

public interface ByteData
extends UploadData {
    public static ByteData of(String data) {
        Preconditions.checkNotNull(data);
        return ByteData.of(data.getBytes(StandardCharsets.UTF_8));
    }

    public static ByteData of(byte[] data) {
        Preconditions.checkNotNull(data);
        return com.teamdev.jxbrowser.net.internal.rpc.ByteData.newBuilder().setData(ByteString.copyFrom(data)).build();
    }

    public static ByteData of(String data, ContentType contentType) {
        Preconditions.checkNotNull(data);
        Preconditions.checkNotNull(contentType);
        return ByteData.of(data.getBytes(StandardCharsets.UTF_8), contentType);
    }

    public static ByteData of(byte[] data, ContentType contentType) {
        Preconditions.checkNotNull(data);
        Preconditions.checkNotNull(contentType);
        return com.teamdev.jxbrowser.net.internal.rpc.ByteData.newBuilder().setData(ByteString.copyFrom(data)).setContentType(com.teamdev.jxbrowser.net.internal.rpc.ContentType.cast(contentType)).build();
    }

    @Override
    default public byte[] bytes() {
        return com.teamdev.jxbrowser.net.internal.rpc.ByteData.cast(this).getData().toByteArray();
    }

    @Override
    default public ContentType contentType() {
        return com.teamdev.jxbrowser.net.internal.rpc.ByteData.cast(this).getContentType();
    }
}

