/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.password;

import com.teamdev.jxbrowser.deps.com.google.common.base.Preconditions;
import com.teamdev.jxbrowser.password.internal.rpc.PasswordRecord;

public interface PasswordRecord {
    public static Builder newBuilder(String url, String password) {
        Preconditions.checkNotNull(url);
        Preconditions.checkNotNull(password);
        return new Builder(url, password);
    }

    default public String url() {
        return com.teamdev.jxbrowser.password.internal.rpc.PasswordRecord.cast(this).getUrl();
    }

    default public String login() {
        return com.teamdev.jxbrowser.password.internal.rpc.PasswordRecord.cast(this).getLogin();
    }

    public static final class Builder {
        private final PasswordRecord.Builder builder;

        private Builder(String url, String password) {
            Preconditions.checkNotNull(url);
            Preconditions.checkNotNull(password);
            this.builder = com.teamdev.jxbrowser.password.internal.rpc.PasswordRecord.newBuilder().setUrl(url).setPassword(password);
        }

        public Builder login(String login) {
            Preconditions.checkNotNull(login);
            this.builder.setLogin(login);
            return this;
        }

        public PasswordRecord build() {
            return this.builder.build();
        }
    }
}

