/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.callback.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.ApproximateBounds;
import com.teamdev.jxbrowser.ui.internal.Geometry;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class OpenBrowserPopupCallback {
    protected static final Size DEFAULT_POPUP_SIZE = Size.of((int)800, (int)600);
    private double decorationWidth;
    private double decorationHeight;

    protected void openBrowser(Browser browser, Rect initialBounds) {
        Platform.runLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            Stage stage = new Stage();
            stage.sizeToScene();
            StackPane root = new StackPane();
            Scene scene = OpenBrowserPopupCallback.createScene(root, initialBounds.size());
            root.getChildren().add((Object)view);
            stage.setScene(scene);
            this.configureStage(stage);
            OpenBrowserPopupCallback.updateOrigin(stage, initialBounds.origin());
            stage.setOnCloseRequest(event -> browser.close());
            browser.on(TitleChanged.class, event -> Platform.runLater(() -> stage.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> Platform.runLater(() -> ((Stage)stage).close()));
            browser.on(UpdateBoundsRequested.class, event -> this.updateBounds((UpdateBoundsRequested)event, stage, view));
            stage.show();
            this.decorationHeight = stage.getHeight() - scene.getHeight();
            this.decorationWidth = stage.getWidth() - scene.getWidth();
        });
    }

    protected void configureStage(Stage stage) {
    }

    private void updateBounds(UpdateBoundsRequested event, Stage stage, BrowserView view) {
        Platform.runLater(() -> {
            Rect popupBounds = event.bounds();
            if (!ApproximateBounds.fuzzyEqual((Size)OpenBrowserPopupCallback.currentSize(view), (Size)popupBounds.size())) {
                this.updateSize(stage, popupBounds.size());
            }
            if (!ApproximateBounds.fuzzyEqual((Point)OpenBrowserPopupCallback.currentOrigin(view), (Point)popupBounds.origin())) {
                OpenBrowserPopupCallback.updateOrigin(stage, popupBounds.origin());
            }
        });
    }

    private static Point currentOrigin(BrowserView view) {
        Point2D viewLocation = view.localToScreen(0.0, 0.0);
        return Geometry.newPoint((double)viewLocation.getX(), (double)viewLocation.getY());
    }

    private static Size currentSize(BrowserView view) {
        Bounds boundsInLocal = view.getBoundsInLocal();
        return Size.of((int)((int)boundsInLocal.getWidth()), (int)((int)boundsInLocal.getHeight()));
    }

    private static Scene createScene(StackPane root, Size size) {
        if (size.isEmpty()) {
            return new Scene((Parent)root, (double)DEFAULT_POPUP_SIZE.width(), (double)DEFAULT_POPUP_SIZE.height());
        }
        return new Scene((Parent)root, (double)size.width(), (double)size.height());
    }

    private static void updateOrigin(Stage stage, Point origin) {
        stage.setX((double)origin.x());
        stage.setY((double)origin.y());
    }

    private void updateSize(Stage stage, Size size) {
        if (size.isEmpty()) {
            stage.setWidth((double)DEFAULT_POPUP_SIZE.width());
            stage.setHeight((double)DEFAULT_POPUP_SIZE.height());
        } else {
            stage.setWidth((double)size.width() + this.decorationWidth);
            stage.setHeight((double)size.height() + this.decorationHeight);
        }
    }
}

