/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.menu.ContextMenuItem;
import com.teamdev.jxbrowser.menu.ContextMenuItemType;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.menu.ContextMenu;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public final class DefaultContextMenu
extends ContextMenu {
    public DefaultContextMenu(BrowserView parent, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        super(parent, params, callback);
    }

    @Override
    protected void initialize(javafx.scene.control.ContextMenu contextMenu) {
        for (ContextMenuItem item : this.params().extensionMenuItems()) {
            this.createCustomMenuItem((ObservableList<MenuItem>)contextMenu.getItems(), item);
        }
    }

    private void createCustomMenuItem(ObservableList<MenuItem> menuItems, ContextMenuItem menuItem) {
        ContextMenuItemType itemType = menuItem.type();
        if (itemType == ContextMenuItemType.ITEM) {
            menuItems.add((Object)this.createCustomMenuItem(menuItem));
        } else if (itemType == ContextMenuItemType.CHECKABLE_ITEM) {
            menuItems.add((Object)this.createCustomCheckedMenuItem(menuItem));
        } else if (itemType == ContextMenuItemType.SEPARATOR) {
            menuItems.add((Object)new SeparatorMenuItem());
        } else if (itemType == ContextMenuItemType.SUB_MENU) {
            menuItems.add((Object)this.createCustomSubMenuItem(menuItem));
        }
    }

    private MenuItem createCustomMenuItem(ContextMenuItem item) {
        MenuItem menuItem = new MenuItem(item.text());
        menuItem.disableProperty().setValue(Boolean.valueOf(!item.isEnabled()));
        menuItem.setOnAction(e -> this.callback().select(item));
        return menuItem;
    }

    private MenuItem createCustomCheckedMenuItem(ContextMenuItem item) {
        CheckMenuItem menuItem = new CheckMenuItem(item.text());
        menuItem.setSelected(item.isChecked());
        menuItem.disableProperty().setValue(Boolean.valueOf(!item.isEnabled()));
        menuItem.setOnAction(e -> this.callback().select(item));
        return menuItem;
    }

    private Menu createCustomSubMenuItem(ContextMenuItem item) {
        Menu menu = new Menu(item.text());
        for (ContextMenuItem contextMenuItem : item.items()) {
            this.createCustomMenuItem((ObservableList<MenuItem>)menu.getItems(), contextMenuItem);
        }
        return menu;
    }
}

