/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.menu;

import com.teamdev.jxbrowser.browser.callback.internal.ShowSuggestionsCallback;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.SystemProperties;
import com.teamdev.jxbrowser.internal.rpc.BrowserId;
import com.teamdev.jxbrowser.internal.rpc.Suggestion;
import com.teamdev.jxbrowser.suggestions.SuggestionsPopupType;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public final class SuggestionsPopup {
    private static final Map<BrowserId, SuggestionsPopup> OPEN_POPUPS = new ConcurrentHashMap<BrowserId, SuggestionsPopup>();
    private final ShowSuggestionsCallback.Params params;
    private final ShowSuggestionsCallback.Action callback;
    private final BrowserId browserId;
    private final BrowserView parent;
    private final ContextMenu suggestionsPopup;

    static Optional<SuggestionsPopup> fromBrowser(BrowserId id) {
        return Optional.ofNullable(OPEN_POPUPS.get(id));
    }

    public SuggestionsPopup(BrowserView parent, ShowSuggestionsCallback.Params params, ShowSuggestionsCallback.Action callback) {
        this.parent = parent;
        this.params = params;
        this.callback = callback;
        this.browserId = ((BrowserImpl)parent.getBrowser()).id();
        SuggestionsPopup.fromBrowser(this.browserId).ifPresent(SuggestionsPopup::hide);
        this.suggestionsPopup = new ContextMenu();
        if (SystemProperties.hasProperty((String)"jxbrowser.native.keyboard.input.enabled")) {
            this.suggestionsPopup.addEventFilter(KeyEvent.ANY, event -> {
                if (event.getCode() == KeyCode.ENTER) {
                    event.consume();
                }
            });
        }
    }

    private void addSuggestions(List<Suggestion> suggestions) {
        for (int i = 0; i < suggestions.size(); ++i) {
            Suggestion suggestion = suggestions.get(i);
            MenuItem suggestionItem = this.createSuggestionItem(this.params, suggestion);
            this.suggestionsPopup.getItems().add(i, (Object)suggestionItem);
            suggestionItem.setOnAction(e -> this.callback.accept(suggestion));
        }
    }

    private MenuItem createSuggestionItem(ShowSuggestionsCallback.Params params, Suggestion suggestion) {
        MenuItem suggestionItem = new MenuItem();
        String text = params.popupType() == SuggestionsPopupType.PASSWORDS ? String.format("%s\n%s", suggestion.getValue(), suggestion.getHiddenPassword()) : (params.popupType() == SuggestionsPopupType.ADDRESSES ? String.format("%s\n%s", suggestion.getValue(), suggestion.getAddressOrFullname()) : (params.popupType() == SuggestionsPopupType.CREDIT_CARDS ? String.format("%s\n%s", suggestion.getValue(), suggestion.getCreditCardInfo()) : suggestion.getValue()));
        Label label = new Label(text);
        suggestionItem.setGraphic((Node)label);
        return suggestionItem;
    }

    private Point popupLocation() {
        com.teamdev.jxbrowser.ui.internal.rpc.Point locationInBrowser = this.params.location();
        Bounds parentBoundsInLocal = this.parent.getBoundsInLocal();
        Bounds parentLocationOnScreen = this.parent.localToScreen(parentBoundsInLocal);
        double parentX = parentLocationOnScreen.getMinX();
        double parentY = parentLocationOnScreen.getMinY();
        Point popupLocationOnScreen = Point.of((int)((int)(parentX + (double)locationInBrowser.x())), (int)((int)(parentY + (double)locationInBrowser.y())));
        return popupLocationOnScreen;
    }

    public void show() {
        this.suggestionsPopup.setAutoHide(false);
        this.suggestionsPopup.setOnHidden(event -> {
            if (!this.callback.isClosed()) {
                this.callback.cancel();
            }
            OPEN_POPUPS.remove(this.browserId);
        });
        this.addSuggestions(this.params.suggestions());
        Point location = this.popupLocation();
        Platform.runLater(() -> {
            this.suggestionsPopup.show(this.parent.getScene().getWindow(), (double)location.x(), (double)location.y());
            OPEN_POPUPS.put(this.browserId, this);
        });
    }

    void updateSuggestions(List<Suggestion> updatedSuggestions) {
        Platform.runLater(() -> {
            this.suggestionsPopup.getItems().removeAll((Collection)this.suggestionsPopup.getItems());
            this.addSuggestions(updatedSuggestions);
        });
    }

    void hide() {
        Platform.runLater(() -> ((ContextMenu)this.suggestionsPopup).hide());
    }
}

