/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.internal.AccessibilityNode;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.WebDialog;
import com.teamdev.jxbrowser.browser.internal.callback.BrowserWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.callback.CreateWebDialogCallback;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.CreateWebDialog;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogBoundsUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogClosed;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.browser.internal.rpc.PaintRequest;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.javafx.BrowserView;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.ContentNode;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.Graphics2dWebDialogView;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.MemoryImage;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Affine;
import javax.annotation.CheckForNull;

public final class Graphics2dRenderWidget
extends OffScreenRenderWidget<Canvas> {
    private final MemoryImage memoryImage = new MemoryImage();
    private final AccessibilityNode accessibleWebView;
    private final AccessibilityNode accessibleWebDialog;

    public Graphics2dRenderWidget(BrowserWidget widget, BrowserView browserView) {
        super(widget, browserView, new ContentCanvas());
        this.accessibleWebView = AccessibilityNode.create((BrowserWidget)widget);
        this.accessibleWebDialog = AccessibilityNode.create((BrowserWidget)widget);
        widget.set(PaintCallback.class, (BrowserWidgetCallback)new OnPaint());
        widget.set(CreateWebDialogCallback.class, (BrowserWidgetCallback)((CreateWebDialogCallback)params -> {
            WebDialog webDialog = new WebDialog(widget.browser(), params.getWebDialogId());
            Graphics2dWebDialogView webDialogView = new Graphics2dWebDialogView(webDialog);
            this.node().ifPresent(node -> {
                webDialogView.addEventHandler(EventType.ROOT, arg_0 -> ((Canvas)node).fireEvent(arg_0));
                Platform.runLater(() -> {
                    Rect initialBounds = params.getInitialBounds();
                    webDialogView.setSize(initialBounds.size());
                    Point origin = initialBounds.getOrigin();
                    StackPane.setMargin((Node)webDialogView, (Insets)new Insets((double)origin.y(), 0.0, 0.0, (double)origin.x()));
                    StackPane.setAlignment((Node)webDialogView, (Pos)Pos.TOP_LEFT);
                    browserView.getChildren().add((Object)webDialogView);
                    browserView.layout();
                    NativeAwareWindow awareWindow = this.window();
                    awareWindow.findNativeId().ifPresent(parentViewId -> this.accessibleWebDialog.add(parentViewId.longValue(), parentViewId.longValue()));
                });
                webDialog.on(DialogBoundsUpdated.class, e -> Platform.runLater(() -> {
                    StackPane.setMargin((Node)webDialogView, (Insets)new Insets((double)e.getBounds().y(), 0.0, 0.0, (double)e.getBounds().x()));
                    StackPane.setAlignment((Node)webDialogView, (Pos)Pos.TOP_LEFT);
                    webDialogView.setSize(e.getBounds().size());
                }));
                webDialog.on(DialogClosed.class, e -> Platform.runLater(() -> {
                    webDialogView.close();
                    webDialogView.removeEventHandler(EventType.ROOT, arg_0 -> ((Canvas)node).fireEvent(arg_0));
                    browserView.getChildren().remove((Object)webDialogView);
                    browserView.layout();
                    this.accessibleWebDialog.remove();
                }));
            });
            return CreateWebDialog.Response.newBuilder().build();
        }));
    }

    @Override
    protected void close() {
        this.widget.remove(PaintCallback.class);
        this.widget.remove(CreateWebDialogCallback.class);
        super.close();
    }

    @Override
    protected void show() {
        if (this.isWidgetShown() || this.window() == null) {
            return;
        }
        super.show();
        this.widget.requestLastRenderedFrame();
        Platform.runLater(this::paint);
        this.window().findNativeId().ifPresent(parentViewId -> this.accessibleWebView.add(parentViewId.longValue(), parentViewId.longValue()));
    }

    @Override
    protected void hide() {
        if (!this.isWidgetShown()) {
            return;
        }
        super.hide();
        this.accessibleWebView.remove();
        this.memoryImage.reset();
    }

    @Override
    protected boolean trackSizeWhenHidden() {
        return false;
    }

    private void paint() {
        this.node().ifPresent(node -> {
            GraphicsContext graphics2d = node.getGraphicsContext2D();
            MemoryImage memoryImage = this.memoryImage;
            synchronized (memoryImage) {
                double deviceScaleFactor = this.memoryImage.getDeviceScaleFactor();
                double scale = 1.0 / deviceScaleFactor;
                Affine transform = graphics2d.getTransform();
                transform.setMxx(scale);
                transform.setMyy(scale);
                graphics2d.setTransform(transform);
                this.memoryImage.image().ifPresent(image -> {
                    graphics2d.clearRect(0.0, 0.0, image.getWidth(), image.getHeight());
                    graphics2d.drawImage((Image)image, 0.0, 0.0, image.getWidth(), image.getHeight());
                });
            }
        });
        this.widget.onPainted();
    }

    static final class ContentCanvas
    extends ContentNode<Canvas> {
        ContentCanvas() {
            super(new Canvas(){

                public void resize(double width, double height) {
                    this.setWidth(width);
                    this.setHeight(height);
                }

                public double maxWidth(double height) {
                    return Double.MAX_VALUE;
                }

                public double maxHeight(double width) {
                    return Double.MAX_VALUE;
                }

                public double prefWidth(double height) {
                    return 0.0;
                }

                public double prefHeight(double width) {
                    return 0.0;
                }

                public boolean isResizable() {
                    return true;
                }
            });
        }

        @Override
        public ReadOnlyDoubleProperty heightProperty() {
            return ((Canvas)this.toolkitNode()).heightProperty();
        }

        @Override
        public ReadOnlyDoubleProperty widthProperty() {
            return ((Canvas)this.toolkitNode()).widthProperty();
        }

        @Override
        public double getHeight() {
            return ((Canvas)this.toolkitNode()).getHeight();
        }

        @Override
        public double getWidth() {
            return ((Canvas)this.toolkitNode()).getWidth();
        }
    }

    private final class OnPaint
    implements PaintCallback {
        private OnPaint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        public Paint.Response on(Paint.Request params) {
            MemoryImage memoryImage = Graphics2dRenderWidget.this.memoryImage;
            synchronized (memoryImage) {
                PaintRequest request = params.getPaintRequest();
                Graphics2dRenderWidget.this.memoryImage.updateImage((Size)request.getViewSize(), (com.teamdev.jxbrowser.ui.Rect)request.getDirtyRect(), request.getMemoryId(), request.getScaleFactor());
            }
            if (Graphics2dRenderWidget.this.isWidgetShown()) {
                Platform.runLater(Graphics2dRenderWidget.this::paint);
            }
            return Paint.Response.getDefaultInstance();
        }
    }
}

