/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.PropertiesConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    public static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    public static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners = null;
    ScheduledFuture<?> scheduledFuture;

    @Override
    public void run() {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRunningEvent(this));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        if (configurationWatchList == null) {
            this.addWarn("Empty ConfigurationWatchList in context");
            return;
        }
        if (configurationWatchList.emptyWatchLists()) {
            this.addInfo("Both watch lists are empty. Disabling ");
            return;
        }
        File file = configurationWatchList.changeDetectedInFile();
        URL uRL = configurationWatchList.changeDetectedInURL();
        if (file == null && uRL == null) {
            return;
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectedEvent(this));
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        if (file != null) {
            this.changeInFile(file, configurationWatchList);
        }
        if (uRL != null) {
            this.changeInURL(uRL);
        }
    }

    private void changeInURL(URL uRL) {
        String string = uRL.getPath();
        if (string.endsWith(".properties")) {
            this.runPropertiesConfigurator(uRL);
        }
    }

    private void changeInFile(File serializable, ConfigurationWatchList object) {
        if (((File)serializable).getName().endsWith(".properties")) {
            this.runPropertiesConfigurator(serializable);
            return;
        }
        ReconfigureOnChangeTask reconfigureOnChangeTask = this;
        reconfigureOnChangeTask.addInfo("Will reset and reconfigure context named [" + reconfigureOnChangeTask.context.getName() + "]");
        this.cancelFutureInvocationsOfThisTaskInstance();
        serializable = ((ConfigurationWatchList)object).getMainURL();
        object = (LoggerContext)this.context;
        if (((URL)serializable).toString().endsWith("xml")) {
            this.performXMLConfiguration((LoggerContext)object, (URL)serializable);
            return;
        }
        if (((URL)serializable).toString().endsWith("groovy")) {
            this.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
    }

    private void runPropertiesConfigurator(Object object) {
        this.addInfo("Will run PropertyConfigurator on " + String.valueOf(object));
        PropertiesConfigurator propertiesConfigurator = new PropertiesConfigurator();
        ((ContextAwareBase)propertiesConfigurator).setContext(this.context);
        try {
            if (object instanceof File) {
                File file = (File)object;
                propertiesConfigurator.doConfigure(file);
            } else if (object instanceof URL) {
                URL uRL = (URL)object;
                propertiesConfigurator.doConfigure(uRL);
            }
            this.context.fireConfigurationEvent(ConfigurationEvent.newPartialConfigurationEndedSuccessfullyEvent(this));
            return;
        }
        catch (JoranException joranException) {
            this.addError("Failed to reload " + String.valueOf(object));
            return;
        }
    }

    private void cancelFutureInvocationsOfThisTaskInstance() {
        boolean bl2 = this.scheduledFuture.cancel(false);
        if (!bl2) {
            ReconfigureOnChangeTask reconfigureOnChangeTask = this;
            reconfigureOnChangeTask.addWarn("could not cancel " + reconfigureOnChangeTask.toString());
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        Model model = joranConfigurator.recallSafeConfiguration();
        URL uRL2 = ConfigurationWatchListUtil.getMainWatchURL(this.context);
        this.addInfo("Resetting loggerContext [" + loggerContext.getName() + "]");
        ((ContextBase)loggerContext).reset();
        long l2 = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(uRL);
            if (statusUtil.hasXMLParsingErrors(l2)) {
                this.fallbackConfiguration(loggerContext, model, uRL2);
            }
            return;
        }
        catch (JoranException joranException) {
            this.addWarn("Exception occurred during reconfiguration", joranException);
            this.fallbackConfiguration(loggerContext, model, uRL2);
            return;
        }
    }

    private void fallbackConfiguration(LoggerContext loggerContext, Model model, URL object) {
        object = new JoranConfigurator();
        ((ContextAwareBase)object).setContext(this.context);
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList(this.context);
        configurationWatchList = configurationWatchList.buildClone();
        if (model == null) {
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        this.addInfo("Safe model " + String.valueOf(model));
        try {
            ((ContextBase)loggerContext).reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList(this.context, configurationWatchList);
            ModelUtil.resetForReuse(model);
            ((GenericXMLConfigurator)object).processModel(model);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            ((GenericXMLConfigurator)object).registerSafeConfiguration(model);
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedSuccessfullyEvent(this));
            return;
        }
        catch (Exception exception) {
            this.addError("Unexpected exception thrown by a configuration considered safe.", exception);
            return;
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }

    @Deprecated
    public void setScheduredFuture(ScheduledFuture<?> scheduledFuture) {
        this.setScheduledFuture(scheduledFuture);
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }
}

