/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.ModelClassToModelHandlerLinker;
import ch.qos.logback.classic.joran.serializedModel.HardenedModelInputStream;
import ch.qos.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.Configurator$ExecutionStatus;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.ModelClassToModelHandlerLinkerBase;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;

@ConfiguratorRank(value=10)
public class SerializedModelConfigurator
extends ContextAwareBase
implements Configurator {
    public static final String AUTOCONFIG_MODEL_FILE = "logback.scmo";
    public static final String TEST_AUTOCONFIG_MODEL_FILE = "logback-test.scmo";
    protected ModelInterpretationContext modelInterpretationContext;

    @Override
    public Configurator$ExecutionStatus configure(LoggerContext object) {
        object = this.performMultiStepModelFileSearch(true);
        if (object != null) {
            this.addWarn("Replaced by logback-tyler, SerializedModelConfigurator has been deprecated and will be removed on 2025-07-01.");
            this.configureByResource((URL)object);
            return Configurator$ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator$ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    private void configureByResource(URL serializable) {
        Object object = serializable.toString();
        if (((String)object).endsWith(".scmo")) {
            if ((serializable = this.retrieveModel((URL)serializable)) == null) {
                this.addWarn("Empty model. Abandoning.");
                return;
            }
            ModelUtil.resetForReuse((Model)serializable);
            this.buildModelInterpretationContext((Model)serializable);
            object = new DefaultProcessor(this.context, this.modelInterpretationContext);
            Object object2 = new ModelClassToModelHandlerLinker(this.context);
            ((ModelClassToModelHandlerLinkerBase)object2).link((DefaultProcessor)object);
            object2 = this.context.getConfigurationLock();
            try {
                ((ReentrantLock)object2).lock();
                ((DefaultProcessor)object).process((Model)serializable);
            }
            finally {
                ((ReentrantLock)object2).unlock();
            }
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + serializable.toString() + "]. Should be .scmo");
        }
    }

    private void buildModelInterpretationContext(Model model) {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context, this);
        this.modelInterpretationContext.setTopModel(model);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(this.modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.modelInterpretationContext.createAppenderBags();
    }

    private Model retrieveModel(URL uRL) {
        block10: {
            Model model;
            block9: {
                long l2 = System.currentTimeMillis();
                InputStream inputStream = uRL.openStream();
                try {
                    HardenedModelInputStream hardenedModelInputStream = new HardenedModelInputStream(inputStream);
                    Model model2 = (Model)hardenedModelInputStream.readObject();
                    long l3 = System.currentTimeMillis() - l2;
                    this.addInfo("Model at [" + String.valueOf(uRL) + "] read in " + l3 + " milliseconds");
                    model = model2;
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        this.addError("Failed to open " + String.valueOf(uRL), iOException);
                        break block10;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.addError("Failed read model object in " + String.valueOf(uRL), classNotFoundException);
                    }
                }
                inputStream.close();
            }
            return model;
        }
        return null;
    }

    private URL performMultiStepModelFileSearch(boolean bl2) {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(this);
        URL uRL = this.findModelConfigFileURLFromSystemProperties(classLoader);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(TEST_AUTOCONFIG_MODEL_FILE, classLoader, bl2);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.getResource(AUTOCONFIG_MODEL_FILE, classLoader, bl2);
        return uRL;
    }

    URL findModelConfigFileURLFromSystemProperties(ClassLoader object) {
        String string = OptionHelper.getSystemProperty("logback.scmoFile");
        if (string != null) {
            URL uRL = null;
            try {
                URL uRL2 = uRL = new URL(string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                uRL = Loader.getResource(string, (ClassLoader)object);
                if (uRL != null) {
                    object = uRL;
                    return object;
                }
                object = new File(string);
                if (((File)object).exists() && ((File)object).isFile()) {
                    try {
                        uRL = ((File)object).toURI().toURL();
                        object = uRL;
                        return object;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
            }
            finally {
                this.statusOnResourceSearch(string, uRL);
            }
        }
        return null;
    }

    private URL getResource(String string, ClassLoader object, boolean bl2) {
        object = Loader.getResource(string, (ClassLoader)object);
        if (bl2) {
            this.statusOnResourceSearch(string, (URL)object);
        }
        return object;
    }

    private void statusOnResourceSearch(String string, URL uRL) {
        StatusManager statusManager = this.context.getStatusManager();
        if (uRL == null) {
            statusManager.add(new InfoStatus("Could NOT find resource [" + string + "]", this.context));
            return;
        }
        statusManager.add(new InfoStatus("Found resource [" + string + "] at [" + uRL.toString() + "]", this.context));
    }
}

