/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.layout;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.util.CachingDateFormatter;
import org.slf4j.event.KeyValuePair;

public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();
    static final char DOUBLE_QUOTE_CHAR = '\"';

    @Override
    public void start() {
        ((DynamicConverter)this.tpc).start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent object) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = object.getTimeStamp();
        stringBuilder.append(this.cachingDateFormatter.format(l2));
        stringBuilder.append(" [");
        stringBuilder.append(object.getThreadName());
        stringBuilder.append("] ");
        stringBuilder.append(object.getLevel().toString());
        stringBuilder.append(" ");
        stringBuilder.append(object.getLoggerName());
        stringBuilder.append(" -");
        this.kvp((ILoggingEvent)object, stringBuilder);
        stringBuilder.append("- ");
        stringBuilder.append(object.getFormattedMessage());
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy iThrowableProxy = object.getThrowableProxy();
        if (iThrowableProxy != null) {
            object = this.tpc.convert((ILoggingEvent)object);
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    private void kvp(ILoggingEvent object, StringBuilder stringBuilder) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return;
        }
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i2);
            if (i2 != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(keyValuePair.key));
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append(String.valueOf(keyValuePair.value));
            stringBuilder.append('\"');
        }
    }
}

