/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.Locale;

public class DateConverter
extends ClassicConverter {
    CachingDateFormatter cachingDateFormatter = null;

    @Override
    public void start() {
        Object object;
        String string = this.getFirstOption();
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        } else if (string.equals("ISO8601")) {
            string = "yyyy-MM-dd HH:mm:ss,SSS";
        } else if (string.equals("STRICT")) {
            string = "yyyy-MM-dd'T'HH:mm:ss,SSS";
        }
        Object object2 = this.getOptionList();
        ZoneId zoneId = null;
        if (object2 != null && object2.size() > 1) {
            object = object2.get(1);
            zoneId = ZoneId.of((String)object);
            this.addInfo("Setting zoneId to \"" + String.valueOf(zoneId) + "\"");
        }
        object = null;
        if (object2 != null && object2.size() > 2) {
            object2 = object2.get(2);
            object = Locale.forLanguageTag((String)object2);
            this.addInfo("Setting locale to \"" + String.valueOf(object) + "\"");
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(string, zoneId, (Locale)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + string, illegalArgumentException);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS", zoneId);
        }
        super.start();
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        long l2 = iLoggingEvent.getTimeStamp();
        return this.cachingDateFormatter.format(l2);
    }
}

