/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.JNDIUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    public ContextJNDISelector(LoggerContext loggerContext) {
        this.defaultContext = loggerContext;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    @Override
    public LoggerContext detachLoggerContext(String string) {
        return this.synchronizedContextMap.remove(string);
    }

    @Override
    public LoggerContext getLoggerContext() {
        Object object = null;
        Context context = null;
        LoggerContext loggerContext = threadLocal.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        try {
            context = JNDIUtil.getInitialContext();
            object = JNDIUtil.lookupString(context, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {}
        if (object == null) {
            return this.defaultContext;
        }
        loggerContext = this.synchronizedContextMap.get(object);
        if (loggerContext == null) {
            loggerContext = new LoggerContext();
            ((ContextBase)loggerContext).setName((String)object);
            this.synchronizedContextMap.put((String)object, loggerContext);
            object = this.findConfigFileURL(context, loggerContext);
            if (object != null) {
                this.configureLoggerContextByURL(loggerContext, (URL)object);
            } else {
                try {
                    new ContextInitializer(loggerContext).autoConfig();
                }
                catch (JoranException joranException) {}
            }
            if (!StatusUtil.contextHasStatusListener(loggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
            }
        }
        return loggerContext;
    }

    private String conventionalConfigFileName(String string) {
        return "logback-" + string + ".xml";
    }

    private URL findConfigFileURL(Context object, LoggerContext object2) {
        StatusManager statusManager = ((ContextBase)object2).getStatusManager();
        String string = null;
        try {
            string = JNDIUtil.lookupString((Context)object, "java:comp/env/logback/configuration-resource");
        }
        catch (NamingException namingException) {
            statusManager.add(new WarnStatus("JNDI lookup failed", this, namingException));
        }
        if (string != null) {
            statusManager.add(new InfoStatus("Searching for [" + string + "]", this));
            object = this.urlByResourceName(statusManager, string);
            if (object == null) {
                object2 = "The jndi resource [" + string + "] for context [" + ((ContextBase)object2).getName() + "] does not lead to a valid file";
                statusManager.add(new WarnStatus((String)object2, this));
            }
            return object;
        }
        object = this.conventionalConfigFileName(((ContextBase)object2).getName());
        return this.urlByResourceName(statusManager, (String)object);
    }

    private URL urlByResourceName(StatusManager object, String string) {
        object.add(new InfoStatus("Searching for [" + string + "]", this));
        object = Loader.getResource(string, Loader.getTCL());
        if (object != null) {
            return object;
        }
        return Loader.getResourceBySelfClassLoader(string);
    }

    private void configureLoggerContextByURL(LoggerContext loggerContext, URL uRL) {
        try {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            ((ContextBase)loggerContext).reset();
            joranConfigurator.setContext(loggerContext);
            joranConfigurator.doConfigure(uRL);
        }
        catch (JoranException joranException) {}
        StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
    }

    @Override
    public List<String> getContextNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.synchronizedContextMap.keySet());
        return arrayList;
    }

    @Override
    public LoggerContext getLoggerContext(String string) {
        return this.synchronizedContextMap.get(string);
    }

    public int getCount() {
        return this.synchronizedContextMap.size();
    }

    public void setLocalContext(LoggerContext loggerContext) {
        threadLocal.set(loggerContext);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

