/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.util.LevelUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import ch.qos.logback.core.util.StringUtil;
import java.util.Map;
import java.util.function.Supplier;

public class TylerConfiguratorBase
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    public static final String SET_CONTEXT_METHOD_NAME = "setContext";
    public static final String SET_CONTEXT_NAME_METHOD_NAME = "setContextName";
    public static final String SETUP_LOGGER_METHOD_NAME = "setupLogger";
    public static final String VARIABLE_SUBSTITUTIONS_HELPER_FIELD_NAME = "variableSubstitutionsHelper";
    public static final String PROPERTY_MODEL_HANDLER_HELPER_FIELD_NAME = "propertyModelHandlerHelper";
    protected VariableSubstitutionsHelper variableSubstitutionsHelper;
    protected PropertyModelHandlerHelper propertyModelHandlerHelper = new PropertyModelHandlerHelper(this);

    protected Logger setupLogger(String object, String object2, Boolean bl2) {
        LoggerContext loggerContext = (LoggerContext)this.context;
        object = loggerContext.getLogger((String)object);
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object2)) {
            object2 = LevelUtil.levelStringToLevel((String)object2);
            ((Logger)object).setLevel((Level)object2);
        }
        if (bl2 != null) {
            ((Logger)object).setAdditive(bl2);
        }
        return object;
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
        this.propertyModelHandlerHelper.setContext(context);
    }

    protected void setContextName(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            this.addError("Cannot set context name to null or empty string");
            return;
        }
        try {
            String string2 = this.subst(string);
            this.addInfo("Setting context name to [" + string2 + "]");
            this.context.setName(string2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.addError("Failed to rename context as [" + string + "]");
            return;
        }
    }

    protected void addOnConsoleStatusListener() {
        StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
    }

    @Override
    public String subst(String string) {
        return this.variableSubstitutionsHelper.subst(string);
    }

    @Override
    public void addSubstitutionProperty(String string, String string2) {
        this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
    }

    @Override
    public String getProperty(String string) {
        return this.variableSubstitutionsHelper.getProperty(string);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return this.variableSubstitutionsHelper.getCopyOfPropertyMap();
    }

    public boolean isNull(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        return (string = OptionHelper.propertyLookup(string, tylerConfiguratorBase, tylerConfiguratorBase.context)) == null;
    }

    public boolean isDefined(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        return (string = OptionHelper.propertyLookup(string, tylerConfiguratorBase, tylerConfiguratorBase.context)) != null;
    }

    public String p(String string) {
        return this.property(string);
    }

    public String property(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        if ((string = OptionHelper.propertyLookup(string, tylerConfiguratorBase, tylerConfiguratorBase.context)) != null) {
            return string;
        }
        return "";
    }

    private JoranConfigurator makeAnotherInstance() {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        return joranConfigurator;
    }

    @Override
    public Supplier<? extends GenericXMLConfigurator> getConfiguratorSupplier() {
        Supplier<GenericXMLConfigurator> supplier = () -> this.makeAnotherInstance();
        return supplier;
    }

    protected void processModelFromIncludedFile(Model model) {
        Object object = this.getConfiguratorSupplier();
        object = object.get();
        ConfigurationModel configurationModel = new ConfigurationModel();
        configurationModel.addSubModel(model);
        ((GenericXMLConfigurator)object).processModel(configurationModel);
    }
}

