/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.Configurator$ExecutionStatus;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.classic.util.ContextInitializer$1;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.util.Comparator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    String[] INTERNAL_CONFIGURATOR_CLASSNAME_LIST = new String[]{"ch.qos.logback.classic.joran.SerializedModelConfigurator", "ch.qos.logback.classic.util.DefaultJoranConfigurator", "ch.qos.logback.classic.BasicConfigurator"};
    final LoggerContext loggerContext;
    final ContextAware contextAware;
    Comparator<Configurator> rankComparator = new ContextInitializer$1(this);

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.contextAware = new ContextAwareImpl(loggerContext, this);
    }

    public void autoConfig() throws JoranException {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) throws JoranException {
        classLoader = Loader.systemClassloaderIfNull(classLoader);
        this.checkVersions();
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        String[] stringArray = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        stringArray.sort(this.rankComparator);
        if (stringArray.isEmpty()) {
            this.contextAware.addInfo("No custom configurators were discovered as a service.");
        } else {
            this.printConfiguratorOrder((List<Configurator>)stringArray);
        }
        for (Configurator configurator : stringArray) {
            if (this.invokeConfigure(configurator) != Configurator$ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
        stringArray = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST;
        int n2 = this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stringArray[i2];
            this.contextAware.addInfo("Trying to configure with " + (String)object);
            object = this.instantiateConfiguratorByClassName((String)object, classLoader);
            if (object == null || this.invokeConfigure((Configurator)object) != Configurator$ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
    }

    private void checkVersions() {
        String string;
        String string2 = ClassicEnvUtil.getVersionOfLogbackClassic();
        if (string2 == null) {
            string2 = "?";
        }
        if ((string = EnvUtil.logbackVersion()) == null) {
            string = "?";
        }
        this.loggerContext.getStatusManager().add(new InfoStatus("This is logback-classic version " + string2, this.loggerContext));
        if (!string.equals(string2)) {
            this.loggerContext.getStatusManager().add(new InfoStatus("This is logback-core version " + string, this.loggerContext));
            this.loggerContext.getStatusManager().add(new WarnStatus("Versions of logback-core and logback-classic are different!", this.loggerContext));
        }
    }

    private Configurator instantiateConfiguratorByClassName(String object, ClassLoader classLoader) {
        try {
            object = classLoader.loadClass((String)object);
            return (Configurator)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            this.contextAware.addInfo("Instantiation failure: " + reflectiveOperationException.toString());
            return null;
        }
    }

    private Configurator$ExecutionStatus invokeConfigure(Configurator configurator) {
        try {
            long l2 = System.currentTimeMillis();
            this.contextAware.addInfo("Constructed configurator of type " + String.valueOf(configurator.getClass()));
            configurator.setContext(this.loggerContext);
            Configurator$ExecutionStatus configurator$ExecutionStatus = configurator.configure(this.loggerContext);
            this.printDuration(l2, configurator, configurator$ExecutionStatus);
            return configurator$ExecutionStatus;
        }
        catch (Exception exception) {
            throw new LogbackException(String.format("Failed to initialize or to run Configurator: %s", configurator != null ? configurator.getClass().getCanonicalName() : "null"), exception);
        }
    }

    private void printConfiguratorOrder(List<Configurator> object) {
        this.contextAware.addInfo("Here is a list of configurators discovered as a service, by rank: ");
        object = object.iterator();
        while (object.hasNext()) {
            Configurator configurator = (Configurator)object.next();
            this.contextAware.addInfo("  " + configurator.getClass().getName());
        }
        this.contextAware.addInfo("They will be invoked in order until ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY is returned.");
    }

    private void printDuration(long l2, Configurator configurator, Configurator$ExecutionStatus configurator$ExecutionStatus) {
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l2;
        this.contextAware.addInfo(configurator.getClass().getName() + ".configure() call lasted " + l4 + " milliseconds. ExecutionStatus=" + String.valueOf((Object)configurator$ExecutionStatus));
    }

    private Configurator$ExecutionStatus attemptConfigurationUsingJoranUsingReflexion(ClassLoader object) {
        try {
            object = ((ClassLoader)object).loadClass("ch.qos.logback.classic.util.DefaultJoranConfigurator");
            object = (Configurator)((Class)object).newInstance();
            object.setContext(this.loggerContext);
            return object.configure(this.loggerContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            this.contextAware.addError("unexpected exception while instantiating DefaultJoranConfigurator", reflectiveOperationException);
            return Configurator$ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
    }

    private int compareRankValue(int n2, int n3) {
        if (n2 > n3) {
            return 1;
        }
        if (n2 == n3) {
            return 0;
        }
        return -1;
    }
}

