/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class LogbackMDCAdapter
implements MDCAdapter {
    final ThreadLocal<Map<String, String>> readWriteThreadLocalMap = new ThreadLocal();
    final ThreadLocal<Map<String, String>> readOnlyThreadLocalMap = new ThreadLocal();
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    @Override
    public void put(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = this.readWriteThreadLocalMap.get();
        if (map == null) {
            map = new HashMap<String, String>();
            this.readWriteThreadLocalMap.set(map);
        }
        map.put(string, string2);
        this.nullifyReadOnlyThreadLocalMap();
    }

    @Override
    public String get(String string) {
        Map<String, String> map = this.readWriteThreadLocalMap.get();
        if (map != null && string != null) {
            return map.get(string);
        }
        return null;
    }

    @Override
    public void remove(String string) {
        if (string == null) {
            return;
        }
        Map<String, String> map = this.readWriteThreadLocalMap.get();
        if (map != null) {
            map.remove(string);
            this.nullifyReadOnlyThreadLocalMap();
        }
    }

    private void nullifyReadOnlyThreadLocalMap() {
        this.readOnlyThreadLocalMap.set(null);
    }

    @Override
    public void clear() {
        this.readWriteThreadLocalMap.set(null);
        this.nullifyReadOnlyThreadLocalMap();
    }

    public Map<String, String> getPropertyMap() {
        Map<String, String> map;
        Map<String, String> map2 = this.readOnlyThreadLocalMap.get();
        if (map2 == null && (map = this.readWriteThreadLocalMap.get()) != null) {
            map2 = new HashMap<String, String>(map);
            map2 = Collections.unmodifiableMap(map2);
            this.readOnlyThreadLocalMap.set(map2);
        }
        return map2;
    }

    public Map getCopyOfContextMap() {
        Map<String, String> map = this.getPropertyMap();
        if (map == null) {
            return null;
        }
        return new HashMap<String, String>(map);
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public void setContextMap(Map map) {
        if (map != null) {
            this.readWriteThreadLocalMap.set(new HashMap(map));
        } else {
            this.readWriteThreadLocalMap.set(null);
        }
        this.nullifyReadOnlyThreadLocalMap();
    }

    @Override
    public void pushByKey(String string, String string2) {
        this.threadLocalMapOfDeques.pushByKey(string, string2);
    }

    @Override
    public String popByKey(String string) {
        return this.threadLocalMapOfDeques.popByKey(string);
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String string) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(string);
    }

    @Override
    public void clearDequeByKey(String string) {
        this.threadLocalMapOfDeques.clearDequeByKey(string);
    }
}

