/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.helpers.ThreadLocalMapOfStacks;
import org.slf4j.spi.MDCAdapter;

public class LogbackMDCAdapterSimple
implements MDCAdapter {
    final ThreadLocal<Map<String, String>> threadLocalUnmodifiableMap = new ThreadLocal();
    private final ThreadLocalMapOfStacks threadLocalMapOfDeques = new ThreadLocalMapOfStacks();

    private Map<String, String> duplicateMap(Map<String, String> map) {
        if (map != null) {
            return new HashMap<String, String>(map);
        }
        return new HashMap<String, String>();
    }

    @Override
    public void put(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> map = this.threadLocalUnmodifiableMap.get();
        map = this.duplicateMap(map);
        map.put(string, string2);
        this.makeUnmodifiableAndThreadLocalSet(map);
    }

    private void makeUnmodifiableAndThreadLocalSet(Map<String, String> map) {
        map = Collections.unmodifiableMap(map);
        this.threadLocalUnmodifiableMap.set(map);
    }

    @Override
    public void remove(String string) {
        if (string == null) {
            return;
        }
        Map<String, String> map = this.threadLocalUnmodifiableMap.get();
        if (map == null) {
            return;
        }
        map = this.duplicateMap(map);
        map.remove(string);
        this.makeUnmodifiableAndThreadLocalSet(map);
    }

    @Override
    public void clear() {
        this.threadLocalUnmodifiableMap.remove();
    }

    @Override
    public String get(String string) {
        Map<String, String> map = this.threadLocalUnmodifiableMap.get();
        if (map != null && string != null) {
            return map.get(string);
        }
        return null;
    }

    public Map<String, String> getPropertyMap() {
        return this.threadLocalUnmodifiableMap.get();
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    @Override
    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> map = this.threadLocalUnmodifiableMap.get();
        return this.duplicateMap(map);
    }

    @Override
    public void setContextMap(Map<String, String> map) {
        this.duplicateMap(map);
    }

    @Override
    public void pushByKey(String string, String string2) {
        this.threadLocalMapOfDeques.pushByKey(string, string2);
    }

    @Override
    public String popByKey(String string) {
        return this.threadLocalMapOfDeques.popByKey(string);
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String string) {
        return this.threadLocalMapOfDeques.getCopyOfDequeByKey(string);
    }

    @Override
    public void clearDequeByKey(String string) {
        this.threadLocalMapOfDeques.clearDequeByKey(string);
    }
}

