/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String AnsiConsole_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String JANSI2_OUT_METHOD_NAME = "out";
    private static final String JANSI2_ERR_METHOD_NAME = "err";
    private static final String WRAP_SYSTEM_OUT_METHOD_NAME = "wrapSystemOut";
    private static final String WRAP_SYSTEM_ERR_METHOD_NAME = "wrapSystemErr";
    private static final String SYSTEM_INSTALL_METHOD_NAME = "systemInstall";
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{PrintStream.class};
    private static final String CONSOLE_APPENDER_WARNING_URL = "https://logback.qos.ch/codes.html#slowConsole";

    public void setTarget(String string) {
        ConsoleTarget consoleTarget = ConsoleTarget.findByName(string.trim());
        if (consoleTarget == null) {
            this.targetWarn(string);
            return;
        }
        this.target = consoleTarget;
    }

    public String getTarget() {
        return this.target.getName();
    }

    private void targetWarn(String object) {
        object = new WarnStatus("[" + (String)object + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        object.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus((Status)object);
    }

    @Override
    public void start() {
        this.addInfo("NOTE: Writing to the console can be slow. Try to avoid logging to the ");
        this.addInfo("console in production environments, especially in high volume systems.");
        this.addInfo("See also https://logback.qos.ch/codes.html#slowConsole");
        OutputStream outputStream = this.target.getStream();
        if (this.withJansi) {
            outputStream = this.wrapWithJansi(outputStream);
        }
        this.setOutputStream(outputStream);
        super.start();
    }

    private OutputStream wrapWithJansi(OutputStream outputStream) {
        try {
            this.addInfo("Enabling JANSI AnsiPrintStream for the console.");
            Object object = Loader.getClassLoaderOfObject(this.context);
            object = ((ClassLoader)object).loadClass(AnsiConsole_CLASS_NAME);
            Optional<Method> optional = ((Class)object).getMethod(SYSTEM_INSTALL_METHOD_NAME, new Class[0]);
            if (optional != null) {
                ((Method)((Object)optional)).invoke(null, new Object[0]);
            }
            optional = this.target == ConsoleTarget.SystemOut ? JANSI2_OUT_METHOD_NAME : JANSI2_ERR_METHOD_NAME;
            optional = Arrays.stream(((Class)object).getMethods()).filter(arg_0 -> ConsoleAppender.lambda$wrapWithJansi$0((String)((Object)optional), arg_0)).filter(method -> method.getParameters().length == 0).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> PrintStream.class.isAssignableFrom(method.getReturnType())).findAny();
            if (optional.isPresent()) {
                optional = optional.orElseThrow(() -> new NoSuchElementException("No out/err method present"));
                return (PrintStream)((Method)((Object)optional)).invoke(null, new Object[0]);
            }
            optional = this.target == ConsoleTarget.SystemOut ? WRAP_SYSTEM_OUT_METHOD_NAME : WRAP_SYSTEM_ERR_METHOD_NAME;
            object = ((Class)object).getMethod((String)((Object)optional), ARGUMENT_TYPES);
            return (OutputStream)((Method)object).invoke(null, new PrintStream(outputStream));
        }
        catch (Exception exception) {
            this.addWarn("Failed to create AnsiPrintStream. Falling back on the default stream.", exception);
            return outputStream;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    public void setWithJansi(boolean bl2) {
        this.withJansi = bl2;
    }

    private static /* synthetic */ boolean lambda$wrapWithJansi$0(String string, Method method) {
        return method.getName().equals(string);
    }
}

