/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public abstract class BaseModelAction
extends Action {
    Model parentModel;
    Model currentModel;
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes) throws ActionException {
        this.parentModel = null;
        this.inError = false;
        if (!this.validPreconditions(saxEventInterpretationContext, string, attributes)) {
            this.inError = true;
            return;
        }
        this.currentModel = this.buildCurrentModel(saxEventInterpretationContext, string, attributes);
        this.currentModel.setTag(string);
        if (!saxEventInterpretationContext.isModelStackEmpty()) {
            this.parentModel = saxEventInterpretationContext.peekModel();
        }
        int n2 = BaseModelAction.getLineNumber(saxEventInterpretationContext);
        this.currentModel.setLineNumber(n2);
        saxEventInterpretationContext.pushModel(this.currentModel);
    }

    protected abstract Model buildCurrentModel(SaxEventInterpretationContext var1, String var2, Attributes var3);

    protected boolean validPreconditions(SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes) {
        return true;
    }

    @Override
    public void body(SaxEventInterpretationContext saxEventInterpretationContext, String string) throws ActionException {
        if (this.currentModel == null) {
            throw new ActionException("current model is null. Is <configuration> element missing?");
        }
        this.currentModel.addText(string);
    }

    @Override
    public void end(SaxEventInterpretationContext saxEventInterpretationContext, String object) throws ActionException {
        if (this.inError) {
            return;
        }
        object = saxEventInterpretationContext.peekModel();
        if (object != this.currentModel) {
            this.addWarn("The object " + String.valueOf(object) + "] at the top of the stack differs from the model [" + this.currentModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.currentModel);
            saxEventInterpretationContext.popModel();
        }
    }
}

