/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.ResourceHandlerBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class IncludeModelHandler
extends ResourceHandlerBase {
    boolean inError = false;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model model) throws ModelHandlerException {
        if ((object = this.buildModelFromIncludedFile((ContextAwarePropertyContainer)object, (IncludeModel)(model = (IncludeModel)model))) == null) {
            this.warnIfRequired("Failed to build include model from included file");
            return;
        }
        this.processModelFromIncludedFile((IncludeModel)model, (Model)object);
    }

    public Model buildModelFromIncludedFile(ContextAwarePropertyContainer object, IncludeModel object2) throws ModelHandlerException {
        this.optional = OptionHelper.toBoolean(((ResourceModel)object2).getOptional(), false);
        if (!this.checkAttributes((ResourceModel)object2)) {
            this.inError = true;
            return null;
        }
        if ((object2 = this.getInputStream((ContextAwarePropertyContainer)object, (IncludeModel)object2)) == null) {
            this.inError = true;
            return null;
        }
        try {
            object2 = this.populateSaxEventRecorder((InputStream)object2);
            List<SaxEvent> list = ((SaxEventRecorder)object2).getSaxEventList();
            if (list.isEmpty()) {
                this.addWarn("Empty sax event list");
                return null;
            }
            if ((object = object.getConfiguratorSupplier()) == null) {
                IncludeModelHandler includeModelHandler = this;
                includeModelHandler.addError("null configurator supplier. Abandoning inclusion of [" + includeModelHandler.attributeInUse + "]");
                this.inError = true;
                return null;
            }
            object = (GenericXMLConfigurator)object.get();
            ((GenericXMLConfigurator)object).getRuleStore().addPathPathMapping("included", "configuration");
            object = ((GenericXMLConfigurator)object).buildModelFromSaxEventList(((SaxEventRecorder)object2).getSaxEventList());
            return object;
        }
        catch (JoranException joranException) {
            this.inError = true;
            IncludeModelHandler includeModelHandler = this;
            includeModelHandler.addError("Error processing XML data in [" + includeModelHandler.attributeInUse + "]", joranException);
            return null;
        }
    }

    private void processModelFromIncludedFile(IncludeModel includeModel, Model model) {
        includeModel.getSubModels().addAll(model.getSubModels());
    }

    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) throws JoranException {
        SaxEventRecorder saxEventRecorder = new SaxEventRecorder(this.context);
        saxEventRecorder.recordEvents(inputStream);
        return saxEventRecorder;
    }

    private InputStream getInputStream(ContextAwarePropertyContainer object, IncludeModel includeModel) {
        if ((object = this.getInputURL((ContextAwarePropertyContainer)object, includeModel)) == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, (URL)object);
        return this.openURL((URL)object);
    }
}

