/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SerializeModelModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class SerializeModelModelHandler
extends ModelHandlerBase {
    public SerializeModelModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new SerializeModelModelHandler(context);
    }

    @Override
    public void handle(ModelInterpretationContext object, Model object2) throws ModelHandlerException {
        Object object3 = ((ModelInterpretationContext)object).getConfiguratorHint();
        if (object3 != null && object3.getClass().getName().equals("ch.qos.logback.classic.joran.SerializedModelConfigurator")) {
            this.addInfo("Skipping model serialization as calling configurator is already model based.");
            return;
        }
        if (!(object2 instanceof SerializeModelModel)) {
            this.addWarn("Model parameter is not of type SerializeModelModel. Skipping serialization of model structure");
            return;
        }
        object2 = (SerializeModelModel)object2;
        object3 = ((ModelInterpretationContext)object).getTopModel();
        if (object3 == null) {
            this.addWarn("Could not find top most model. Skipping serialization of model structure.");
            return;
        }
        if ((object2 = ((SerializeModelModel)object2).getFile()) == null) {
            object = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmm");
            object2 = Instant.now();
            object = ((DateTimeFormatter)object).format((TemporalAccessor)object2);
            object2 = "logback-" + (String)object + ".scmo";
            this.addInfo("For model serialization, using default file destination [" + (String)object2 + "]");
        } else {
            object2 = ((ModelInterpretationContext)object).subst((String)object2);
        }
        this.writeModel((String)object2, (Model)object3);
    }

    private void writeModel(String string, Model model) {
        this.addInfo("Serializing model to file [" + string + "]");
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(model);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            this.addError("IO failure while serializing Model [" + string + "]");
        }
    }
}

