/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    Boolean effectivelyAdded = null;
    StatusListener statusListener = null;

    public StatusListenerModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new StatusListenerModelHandler(context);
    }

    protected Class<StatusListenerModel> getSupportedModelClass() {
        return StatusListenerModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        String string = ((ComponentModel)(model = (StatusListenerModel)model)).getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.addError("Empty class name for StatusListener");
            this.inError = true;
            return;
        }
        string = modelInterpretationContext.getImport(string);
        try {
            this.statusListener = (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, this.context);
            this.effectivelyAdded = modelInterpretationContext.getContext().getStatusManager().add(this.statusListener);
            if (this.statusListener instanceof ContextAware) {
                ((ContextAware)((Object)this.statusListener)).setContext(this.context);
            }
            this.addInfo("Added status listener of type [" + ((ComponentModel)model).getClassName() + "]");
            modelInterpretationContext.pushObject(this.statusListener);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an StatusListener of type [" + ((ComponentModel)model).getClassName() + "].", exception);
            throw new ModelHandlerException(exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) {
        if (this.inError) {
            return;
        }
        if (this.isEffectivelyAdded() && this.statusListener instanceof LifeCycle) {
            ((LifeCycle)((Object)this.statusListener)).start();
        }
        if ((object = modelInterpretationContext.peekObject()) != this.statusListener) {
            this.addWarn("The object at the of the stack is not the statusListener pushed earlier.");
            return;
        }
        modelInterpretationContext.popObject();
    }

    private boolean isEffectivelyAdded() {
        if (this.effectivelyAdded == null) {
            return false;
        }
        return this.effectivelyAdded;
    }
}

