/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.conditional.IfModel;
import ch.qos.logback.core.model.conditional.IfModel$BranchState;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.OptionHelper;

public class IfModelHandler
extends ModelHandlerBase {
    public static final String MISSING_JANINO_MSG = "Could not find Janino library on the class path. Skipping conditional processing.";
    public static final String MISSING_JANINO_SEE = "See also https://logback.qos.ch/codes.html#ifJanino";
    public static final String NEW_OPERATOR_DISALLOWED_MSG = "The 'condition' attribute may not contain the 'new' operator.";
    public static final String NEW_OPERATOR_DISALLOWED_SEE = "See also https://logback.qos.ch/codes.html#conditionNew";
    public static final String CONDITION_ATTR_DEPRECATED_MSG = "The 'condition' attribute in <if> element is deprecated and slated for removal. Use <condition> element instead.";
    public static final String CONDITION_ATTR_DEPRECATED_SEE = "See also https://logback.qos.ch/codes.html#conditionAttributeDeprecation";
    IfModel ifModel = null;

    public IfModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new IfModelHandler(context);
    }

    protected Class<IfModel> getSupportedModelClass() {
        return IfModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) throws ModelHandlerException {
        this.ifModel = (IfModel)object;
        modelInterpretationContext.pushModel(this.ifModel);
        Object object2 = modelInterpretationContext.peekObject();
        String string = this.ifModel.getCondition();
        this.emitDeprecationWarningIfNecessary(string);
        if (object2 instanceof IfModel$BranchState) {
            object = (IfModel$BranchState)((Object)object2);
            this.ifModel.setBranchState((IfModel$BranchState)((Object)object));
            modelInterpretationContext.popObject();
            return;
        }
        this.janinoFallback(modelInterpretationContext, (Model)object, string);
    }

    private void janinoFallback(ModelInterpretationContext object, Model model, String string) {
        if (!EnvUtil.isJaninoAvailable()) {
            this.addError(MISSING_JANINO_MSG);
            this.addError(MISSING_JANINO_SEE);
            return;
        }
        int n2 = model.getLineNumber();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            try {
                string = OptionHelper.substVars(string, (PropertyContainer)object, this.context);
            }
            catch (ScanException scanException) {
                this.addError("Failed to parse input [" + string + "] on line " + n2, scanException);
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                return;
            }
            if (this.hasNew(string)) {
                this.addError(NEW_OPERATOR_DISALLOWED_MSG);
                this.addError(NEW_OPERATOR_DISALLOWED_SEE);
                return;
            }
            try {
                object = new PropertyEvalScriptBuilder((PropertyContainer)object);
                ((ContextAwareBase)object).setContext(this.context);
                object = ((PropertyEvalScriptBuilder)object).build(string);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
                this.addError("Failed to parse condition [" + string + "] on line " + n2, throwable);
                return;
            }
            if (object != null) {
                boolean bl2 = object.evaluate();
                this.addInfo("Condition [" + string + "] evaluated to " + bl2 + " on line " + n2);
                this.ifModel.setBranchState(bl2);
                return;
            }
            this.addError("The condition variable is null. This should not occur.");
            this.ifModel.setBranchState(IfModel$BranchState.IN_ERROR);
            return;
        }
    }

    private void emitDeprecationWarningIfNecessary(String string) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.addWarn(CONDITION_ATTR_DEPRECATED_MSG);
            this.addWarn(CONDITION_ATTR_DEPRECATED_SEE);
        }
    }

    private boolean hasNew(String string) {
        return string.contains("new ");
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        if (modelInterpretationContext.isModelStackEmpty()) {
            this.addError("Unexpected unexpected empty model stack.");
            return;
        }
        model = modelInterpretationContext.peekModel();
        if (model != this.ifModel) {
            this.addWarn("The object [" + String.valueOf(model) + "] on the top the of the stack is not the expected [" + String.valueOf(this.ifModel));
            return;
        }
        modelInterpretationContext.popModel();
    }
}

