/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.util;

import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.action.ActionUtil$Scope;
import ch.qos.logback.core.model.NamedModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyModelHandlerHelper
extends ContextAwareBase {
    public static final String HANDLE_PROPERTY_MODEL_METHOD_NAME = "handlePropertyModel";

    public PropertyModelHandlerHelper(ContextAware contextAware) {
        super(contextAware);
    }

    public void handlePropertyModel(ContextAwarePropertyContainer contextAwarePropertyContainer, String string, String string2, String string3, String string4, String string5) {
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName(string);
        propertyModel.setValue(string2);
        propertyModel.setFile(string3);
        propertyModel.setResource(string4);
        propertyModel.setScopeStr(string5);
        this.handlePropertyModel(contextAwarePropertyContainer, propertyModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePropertyModel(ContextAwarePropertyContainer contextAwarePropertyContainer, PropertyModel object) {
        ActionUtil$Scope actionUtil$Scope = ActionUtil.stringToScope(((PropertyModel)object).getScopeStr());
        if (PropertyModelHandlerHelper.checkFileAttributeSanity((PropertyModel)object)) {
            String string = ((PropertyModel)object).getFile();
            string = contextAwarePropertyContainer.subst(string);
            try {
                object = new FileInputStream(string);
                try {
                    PropertyModelHandlerHelper.loadAndSetProperties(contextAwarePropertyContainer, (InputStream)object, actionUtil$Scope);
                    return;
                }
                finally {
                    ((FileInputStream)object).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + string + "].");
                return;
            }
            catch (IOException | IllegalArgumentException exception) {
                this.addError("Could not read properties file [" + string + "].", exception);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkResourceAttributeSanity((PropertyModel)object)) {
            String string = ((PropertyModel)object).getResource();
            object = Loader.getResourceBySelfClassLoader(string = contextAwarePropertyContainer.subst(string));
            if (object == null) {
                this.addError("Could not find resource [" + string + "].");
                return;
            }
            try {
                InputStream inputStream = ((URL)object).openStream();
                try {
                    PropertyModelHandlerHelper.loadAndSetProperties(contextAwarePropertyContainer, inputStream, actionUtil$Scope);
                    return;
                }
                finally {
                    if (inputStream == null) return;
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.addError("Could not read resource file [" + string + "].", iOException);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkValueNameAttributesSanity((PropertyModel)object)) {
            String string = ((PropertyModel)object).getValue();
            string = string.trim();
            string = contextAwarePropertyContainer.subst(string);
            ActionUtil.setProperty(contextAwarePropertyContainer, ((NamedModel)object).getName(), string, actionUtil$Scope);
            return;
        }
        this.addError("In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.");
    }

    public static boolean checkFileAttributeSanity(PropertyModel object) {
        String string = ((PropertyModel)object).getFile();
        String string2 = ((NamedModel)object).getName();
        String string3 = ((PropertyModel)object).getValue();
        object = ((PropertyModel)object).getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces(string) && OptionHelper.isNullOrEmptyOrAllSpaces(string2) && OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces((String)object);
    }

    public static boolean checkResourceAttributeSanity(PropertyModel object) {
        String string = ((PropertyModel)object).getFile();
        String string2 = ((NamedModel)object).getName();
        String string3 = ((PropertyModel)object).getValue();
        return !OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((PropertyModel)object).getResource())) && OptionHelper.isNullOrEmptyOrAllSpaces(string2) && OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    public static boolean checkValueNameAttributesSanity(PropertyModel object) {
        String string = ((PropertyModel)object).getFile();
        String string2 = ((NamedModel)object).getName();
        String string3 = ((PropertyModel)object).getValue();
        object = ((PropertyModel)object).getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces(string2) && !OptionHelper.isNullOrEmptyOrAllSpaces(string3) && OptionHelper.isNullOrEmptyOrAllSpaces(string) && OptionHelper.isNullOrEmptyOrAllSpaces((String)object);
    }

    public static void setProperty(ContextAwarePropertyContainer contextAwarePropertyContainer, String string, String string2, ActionUtil$Scope actionUtil$Scope) {
        switch (actionUtil$Scope) {
            case LOCAL: {
                contextAwarePropertyContainer.addSubstitutionProperty(string, string2);
                return;
            }
            case CONTEXT: {
                contextAwarePropertyContainer.getContext().putProperty(string, string2);
                return;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty(contextAwarePropertyContainer, string, string2);
            }
        }
    }

    public static void setProperties(ContextAwarePropertyContainer contextAware, Properties properties, ActionUtil$Scope actionUtil$Scope) {
        switch (actionUtil$Scope) {
            case LOCAL: {
                contextAware.addSubstitutionProperties(properties);
                return;
            }
            case CONTEXT: {
                contextAware = new ContextUtil(contextAware.getContext());
                ((ContextUtil)contextAware).addProperties(properties);
                return;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties(contextAware, properties);
            }
        }
    }

    public static void loadAndSetProperties(ContextAwarePropertyContainer contextAwarePropertyContainer, InputStream inputStream, ActionUtil$Scope actionUtil$Scope) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        PropertyModelHandlerHelper.setProperties(contextAwarePropertyContainer, properties, actionUtil$Scope);
    }
}

