/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;

public class HardenedObjectInputStream
extends ObjectInputStream {
    private final List<String> whitelistedClassNames;
    private static final String[] JAVA_PACKAGES = new String[]{"java.lang", "java.util"};
    private static final int DEPTH_LIMIT = 16;
    private static final int ARRAY_LIMIT = 10000;

    public HardenedObjectInputStream(InputStream inputStream, String[] stringArray) throws IOException {
        super(inputStream);
        this.initObjectFilter();
        this.whitelistedClassNames = new ArrayList<String>();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.whitelistedClassNames.add(stringArray[i2]);
            }
        }
    }

    private void initObjectFilter() {
        this.setObjectInputFilter(ObjectInputFilter.Config.createFilter("maxarray=10000;maxdepth=16;"));
    }

    public HardenedObjectInputStream(InputStream inputStream, List<String> list) throws IOException {
        super(inputStream);
        this.initObjectFilter();
        this.whitelistedClassNames = new ArrayList<String>();
        this.whitelistedClassNames.addAll(list);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (!this.isWhitelisted(string)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", objectStreamClass.getName());
        }
        return super.resolveClass(objectStreamClass);
    }

    private boolean isWhitelisted(String string) {
        for (int i2 = 0; i2 < JAVA_PACKAGES.length; ++i2) {
            if (!string.startsWith(JAVA_PACKAGES[i2])) continue;
            return true;
        }
        for (String string2 : this.whitelistedClassNames) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected void addToWhitelist(List<String> list) {
        this.whitelistedClassNames.addAll(list);
    }
}

