/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.server.AbstractServerSocketAppender$1;
import ch.qos.logback.core.net.server.RemoteReceiverClient;
import ch.qos.logback.core.net.server.RemoteReceiverServerListener;
import ch.qos.logback.core.net.server.RemoteReceiverServerRunner;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import javax.net.ServerSocketFactory;

public abstract class AbstractServerSocketAppender<E>
extends AppenderBase<E> {
    public static final int DEFAULT_BACKLOG = 50;
    public static final int DEFAULT_CLIENT_QUEUE_SIZE = 100;
    private int port = 4560;
    private int backlog = 50;
    private int clientQueueSize = 100;
    private String address;
    private ServerRunner<RemoteReceiverClient> runner;

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            Closeable closeable = this.getServerSocketFactory().createServerSocket(this.getPort(), this.getBacklog(), this.getInetAddress());
            closeable = this.createServerListener((ServerSocket)closeable);
            this.runner = this.createServerRunner((ServerListener<RemoteReceiverClient>)closeable, this.getContext().getExecutorService());
            this.runner.setContext(this.getContext());
            this.getContext().getExecutorService().execute(this.runner);
            super.start();
            return;
        }
        catch (Exception exception) {
            this.addError("server startup error: " + String.valueOf(exception), exception);
            return;
        }
    }

    protected ServerListener<RemoteReceiverClient> createServerListener(ServerSocket serverSocket) {
        return new RemoteReceiverServerListener(serverSocket);
    }

    protected ServerRunner<RemoteReceiverClient> createServerRunner(ServerListener<RemoteReceiverClient> serverListener, Executor executor) {
        return new RemoteReceiverServerRunner(serverListener, executor, this.getClientQueueSize());
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.runner.stop();
            super.stop();
            return;
        }
        catch (IOException iOException) {
            this.addError("server shutdown error: " + String.valueOf(iOException), iOException);
            return;
        }
    }

    @Override
    protected void append(E object) {
        if (object == null) {
            return;
        }
        this.postProcessEvent(object);
        object = this.getPST().transform(object);
        this.runner.accept(new AbstractServerSocketAppender$1(this, object));
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    protected ServerSocketFactory getServerSocketFactory() throws Exception {
        return ServerSocketFactory.getDefault();
    }

    protected InetAddress getInetAddress() throws UnknownHostException {
        if (this.getAddress() == null) {
            return null;
        }
        return InetAddress.getByName(this.getAddress());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int n2) {
        this.backlog = n2;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public int getClientQueueSize() {
        return this.clientQueueSize;
    }

    public void setClientQueueSize(int n2) {
        this.clientQueueSize = n2;
    }
}

