/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import ch.qos.logback.core.pattern.color.ConverterSupplierByClassName;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class PatternLayoutBase<E>
extends LayoutBase<E> {
    static final int INTIAL_STRING_BUILDER_SIZE = 256;
    Converter<E> head;
    String pattern;
    protected PostCompileProcessor<E> postCompileProcessor;
    Map<String, Supplier<DynamicConverter>> instanceConverterMap = new HashMap<String, Supplier<DynamicConverter>>();
    protected boolean outputPatternAsHeader = false;

    protected abstract Map<String, Supplier<DynamicConverter>> getDefaultConverterSupplierMap();

    @Deprecated
    public abstract Map<String, String> getDefaultConverterMap();

    public Map<String, Supplier<DynamicConverter>> getEffectiveConverterMap() {
        HashMap<String, Supplier<DynamicConverter>> hashMap = new HashMap<String, Supplier<DynamicConverter>>();
        Map<String, Supplier<DynamicConverter>> map = this.getDefaultConverterSupplierMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        this.caterForLegacyConverterMaps(hashMap);
        map = ((ContextAwareBase)this).getContext();
        if (map != null && (map = (Map)map.getObject("PATTERN_RULE_REGISTRY_FOR_SUPPLIERS")) != null) {
            hashMap.putAll(map);
        }
        hashMap.putAll(this.instanceConverterMap);
        return hashMap;
    }

    private void caterForLegacyConverterMaps(Map<String, Supplier<DynamicConverter>> map) {
        Map<String, String> map2 = (Map<String, String>)this.context.getObject("PATTERN_RULE_REGISTRY");
        this.migrateFromStringMapToSupplierMap(map2, map);
        map2 = this.getDefaultConverterMap();
        this.migrateFromStringMapToSupplierMap(map2, map);
    }

    private void migrateFromStringMapToSupplierMap(Map<String, String> object, Map<String, Supplier<DynamicConverter>> map) {
        if (object == null) {
            return;
        }
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            ConverterSupplierByClassName object2 = new ConverterSupplierByClassName(string, string2);
            object2.setContext(((ContextAwareBase)this).getContext());
            map.put(string, object2);
        }
    }

    @Override
    public void start() {
        if (this.pattern == null || this.pattern.length() == 0) {
            this.addError("Empty or null pattern.");
            return;
        }
        try {
            Parser parser = new Parser(this.pattern);
            if (((ContextAwareBase)this).getContext() != null) {
                parser.setContext(((ContextAwareBase)this).getContext());
            }
            Node node = parser.parse();
            this.head = parser.compile(node, this.getEffectiveConverterMap());
            if (this.postCompileProcessor != null) {
                this.postCompileProcessor.process(this.context, this.head);
            }
            ConverterUtil.setContextForConverters(((ContextAwareBase)this).getContext(), this.head);
            ConverterUtil.startConverters(this.head);
            super.start();
            return;
        }
        catch (ScanException scanException) {
            StatusManager statusManager = ((ContextAwareBase)this).getContext().getStatusManager();
            statusManager.add(new ErrorStatus("Failed to parse pattern \"" + this.getPattern() + "\".", this, scanException));
            return;
        }
    }

    public void setPostCompileProcessor(PostCompileProcessor<E> postCompileProcessor) {
        this.postCompileProcessor = postCompileProcessor;
    }

    protected void setContextForConverters(Converter<E> converter) {
        ConverterUtil.setContextForConverters(((ContextAwareBase)this).getContext(), converter);
    }

    protected String writeLoopOnConverters(E e2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        for (Converter<E> converter = this.head; converter != null; converter = converter.getNext()) {
            converter.write(stringBuilder, e2);
        }
        return stringBuilder.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String toString() {
        return this.getClass().getName() + "(\"" + this.getPattern() + "\")";
    }

    public Map<String, Supplier<DynamicConverter>> getInstanceConverterMap() {
        return this.instanceConverterMap;
    }

    protected String getPresentationHeaderPrefix() {
        return "";
    }

    public boolean isOutputPatternAsHeader() {
        return this.outputPatternAsHeader;
    }

    public void setOutputPatternAsHeader(boolean bl2) {
        this.outputPatternAsHeader = bl2;
    }

    @Override
    public String getPresentationHeader() {
        if (this.outputPatternAsHeader) {
            return this.getPresentationHeaderPrefix() + this.pattern;
        }
        return super.getPresentationHeader();
    }
}

