/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.List;
import java.util.regex.Pattern;

public class ReplacingCompositeConverter<E>
extends CompositeConverter<E> {
    Pattern pattern;
    String regex;
    String replacement;

    @Override
    public void start() {
        List<String> list = this.getOptionList();
        if (list == null) {
            this.addError("at least two options are expected whereas you have declared none");
            return;
        }
        int n2 = list.size();
        if (n2 < 2) {
            this.addError("at least two options are expected whereas you have declared only " + n2 + "as [" + String.valueOf(list) + "]");
            return;
        }
        this.regex = list.get(0);
        this.pattern = Pattern.compile(this.regex);
        this.replacement = list.get(1);
        super.start();
    }

    @Override
    protected String transform(E e2, String string) {
        if (!this.started) {
            return string;
        }
        return this.pattern.matcher(string).replaceAll(this.replacement);
    }
}

