/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;
import java.util.Date;

public class FixedWindowRollingPolicy
extends RollingPolicyBase {
    static final String FNP_NOT_SET = "The \"FileNamePattern\" property must be set before using FixedWindowRollingPolicy. ";
    static final String PRUDENT_MODE_UNSUPPORTED = "See also https://logback.qos.ch/codes.html#tbr_fnp_prudent_unsupported";
    static final String SEE_PARENT_FN_NOT_SET = "Please refer to https://logback.qos.ch/codes.html#fwrp_parentFileName_not_set";
    int maxIndex = 7;
    int minIndex = 1;
    RenameUtil util = new RenameUtil();
    Compressor compressor;
    public static final String ZIP_ENTRY_DATE_PATTERN = "yyyy-MM-dd_HHmm";
    private static int MAX_WINDOW_SIZE = 20;

    @Override
    public void start() {
        Object object;
        int n2;
        this.util.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addError(FNP_NOT_SET);
            this.addError("See also https://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The \"FileNamePattern\" property must be set before using FixedWindowRollingPolicy. See also https://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.determineCompressionMode();
        this.adjustCompressionModeAndFileNamePatternStrIfNecessary();
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        if (this.isParentPrudent()) {
            this.addError("Prudent mode is not supported with FixedWindowRollingPolicy.");
            this.addError(PRUDENT_MODE_UNSUPPORTED);
            throw new IllegalStateException("Prudent mode is not supported.");
        }
        if (this.getParentsRawFileProperty() == null) {
            this.addError("The File name property must be set before using this rolling policy.");
            this.addError(SEE_PARENT_FN_NOT_SET);
            throw new IllegalStateException("The \"File\" option must be set.");
        }
        if (this.maxIndex < this.minIndex) {
            FixedWindowRollingPolicy fixedWindowRollingPolicy = this;
            fixedWindowRollingPolicy.addWarn("MaxIndex (" + fixedWindowRollingPolicy.maxIndex + ") cannot be smaller than MinIndex (" + this.minIndex + ").");
            this.addWarn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        if (this.maxIndex - this.minIndex > (n2 = this.getMaxWindowSize())) {
            this.addWarn("Large window sizes are not allowed.");
            this.maxIndex = this.minIndex + n2;
            FixedWindowRollingPolicy fixedWindowRollingPolicy = this;
            fixedWindowRollingPolicy.addWarn("MaxIndex reduced to " + fixedWindowRollingPolicy.maxIndex);
        }
        if ((object = this.fileNamePattern.getIntegerTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid IntegerToken");
        }
        if (this.compressionMode == CompressionMode.ZIP) {
            FixedWindowRollingPolicy fixedWindowRollingPolicy = this;
            object = fixedWindowRollingPolicy.transformFileNamePatternFromInt2Date(fixedWindowRollingPolicy.fileNamePatternStr);
            this.zipEntryFileNamePattern = new FileNamePattern((String)object, this.context);
        }
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
        super.start();
    }

    protected int getMaxWindowSize() {
        return MAX_WINDOW_SIZE;
    }

    private String transformFileNamePatternFromInt2Date(String string) {
        string = FileFilterUtil.slashify(string);
        string = FileFilterUtil.afterLastSlash(string);
        return string.replace("%i", "%d{yyyy-MM-dd_HHmm}");
    }

    @Override
    public void rollover() throws RolloverFailure {
        if (this.maxIndex >= 0) {
            File file = new File(this.fileNamePattern.convertInt(this.maxIndex));
            if (file.exists()) {
                file.delete();
            }
            for (int i2 = this.maxIndex - 1; i2 >= this.minIndex; --i2) {
                String string = this.fileNamePattern.convertInt(i2);
                File file2 = new File(string);
                if (file2.exists()) {
                    this.util.rename(string, this.fileNamePattern.convertInt(i2 + 1));
                    continue;
                }
                this.addInfo("Skipping roll-over for inexistent file " + string);
            }
            switch (this.compressionMode) {
                case NONE: {
                    this.util.rename(this.getActiveFileName(), this.fileNamePattern.convertInt(this.minIndex));
                    return;
                }
                case GZ: 
                case XZ: {
                    this.compressor.compress(this.getActiveFileName(), this.fileNamePattern.convertInt(this.minIndex), null);
                    return;
                }
                case ZIP: {
                    this.compressor.compress(this.getActiveFileName(), this.fileNamePattern.convertInt(this.minIndex), this.zipEntryFileNamePattern.convert(new Date()));
                }
            }
        }
    }

    @Override
    public String getActiveFileName() {
        return this.getParentsRawFileProperty();
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int n2) {
        this.maxIndex = n2;
    }

    public void setMinIndex(int n2) {
        this.minIndex = n2;
    }
}

