/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.Loader;

public abstract class RollingPolicyBase
extends ContextAwareBase
implements RollingPolicy {
    protected CompressionMode compressionMode = CompressionMode.NONE;
    FileNamePattern fileNamePattern;
    protected String fileNamePatternStr;
    private FileAppender<?> parent;
    FileNamePattern zipEntryFileNamePattern;
    private boolean started;

    protected void determineCompressionMode() {
        if (this.fileNamePatternStr.endsWith(CompressionMode.GZ_SUFFIX)) {
            this.addInfo("Will use gz compression");
            this.compressionMode = CompressionMode.GZ;
            return;
        }
        if (this.fileNamePatternStr.endsWith(CompressionMode.ZIP_SUFFIX)) {
            this.addInfo("Will use zip compression");
            this.compressionMode = CompressionMode.ZIP;
            return;
        }
        if (this.fileNamePatternStr.endsWith(CompressionMode.XZ_SUFFIX)) {
            this.addInfo("Will use xz compression");
            this.compressionMode = CompressionMode.XZ;
            return;
        }
        this.addInfo("No compression will be used");
        this.compressionMode = CompressionMode.NONE;
    }

    protected void adjustCompressionModeAndFileNamePatternStrIfNecessary() {
        boolean bl2;
        if (this.compressionMode == CompressionMode.XZ && !(bl2 = Loader.isClassLoadable("org.tukaani.xz.XZOutputStream", this.getContext()))) {
            this.addWarn("XZ library missing, falling back to GZ compression");
            this.compressionMode = CompressionMode.GZ;
            this.fileNamePatternStr = this.replaceSuffix(this.fileNamePatternStr, CompressionMode.XZ_SUFFIX, CompressionMode.GZ_SUFFIX);
        }
    }

    private String replaceSuffix(String string, String string2, String string3) {
        int n2 = string2.length();
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - n2) + string3;
        }
        throw new IllegalArgumentException("[" + string + "] should end with " + string2);
    }

    public void setFileNamePattern(String string) {
        this.fileNamePatternStr = string;
    }

    public String getFileNamePattern() {
        return this.fileNamePatternStr;
    }

    @Override
    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public void setParent(FileAppender<?> fileAppender) {
        this.parent = fileAppender;
    }

    public boolean isParentPrudent() {
        return this.parent.isPrudent();
    }

    public String getParentsRawFileProperty() {
        return this.parent.rawFileProperty();
    }
}

