/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.LengthCounter;
import ch.qos.logback.core.rolling.LengthCounterBase;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import java.io.File;

@NoAutoStart
public class SizeAndTimeBasedFileNamingAndTriggeringPolicy<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    volatile int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    Duration checkIncrement = null;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private final SizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage usage;
    public LengthCounter lengthCounter = new LengthCounterBase();

    public SizeAndTimeBasedFileNamingAndTriggeringPolicy() {
        this(SizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage.DIRECT);
    }

    public SizeAndTimeBasedFileNamingAndTriggeringPolicy(SizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage sizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage) {
        this.usage = sizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage;
    }

    @Override
    public void start() {
        super.start();
        if (this.usage == SizeAndTimeBasedFileNamingAndTriggeringPolicy$Usage.DIRECT) {
            this.addWarn("Direct use of either SizeAndTimeBasedFNATP or SizeAndTimeBasedFileNamingAndTriggeringPolicy ");
            this.addWarn("is deprecated. Please use SizeAndTimeBasedRollingPolicy instead.");
            this.addWarn("For more information see https://logback.qos.ch/manual/appenders.html#SizeAndTimeBasedRollingPolicy");
        }
        if (!super.isErrorFree()) {
            return;
        }
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            this.withErrors();
        }
        if (!this.validateDateAndIntegerTokens()) {
            this.withErrors();
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        string = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string);
        if (this.isErrorFree()) {
            this.started = true;
        }
    }

    private boolean validateDateAndIntegerTokens() {
        boolean bl2 = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            bl2 = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also https://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            bl2 = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return !bl2;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    void computeCurrentPeriodsHighestCounterValue(String string) {
        File[] fileArray = new File(((TimeBasedFileNamingAndTriggeringPolicyBase)this).getCurrentPeriodsFileNameWithoutCompressionSuffix());
        fileArray = fileArray.getParentFile();
        if ((fileArray = FileFilterUtil.filesInFolderMatchingStemRegex((File)fileArray, string)) == null || fileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter(fileArray, string);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    @Override
    public boolean isTriggeringEvent(File comparable, E e2) {
        long l2;
        long l3 = this.getCurrentTime();
        if (l3 >= (l2 = this.atomicNextCheck.get())) {
            long l4 = this.computeNextCheck(l3);
            this.atomicNextCheck.set(l4);
            comparable = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(comparable, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(l3);
            this.lengthCounter.reset();
            return true;
        }
        boolean bl2 = this.checkSizeBasedTrigger((File)comparable, l3);
        if (bl2) {
            this.lengthCounter.reset();
        }
        return bl2;
    }

    private boolean checkSizeBasedTrigger(File file, long l2) {
        if (file == null) {
            this.addWarn("activeFile == null");
            return false;
        }
        if (this.maxFileSize == null) {
            this.addWarn("maxFileSize = null");
            return false;
        }
        if (this.lengthCounter.getLength() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    public Duration getCheckIncrement() {
        return null;
    }

    public void setCheckIncrement(Duration duration) {
        this.addWarn("Since version 1.5.8, 'checkIncrement' property has no effect");
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    public void setMaxFileSize(FileSize fileSize) {
        this.maxFileSize = fileSize;
    }

    @Override
    public LengthCounter getLengthCounter() {
        return this.lengthCounter;
    }
}

