/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.RollingCalendar;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.time.Instant;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TimeBasedFileNamingAndTriggeringPolicyBase<E>
extends ContextAwareBase
implements TimeBasedFileNamingAndTriggeringPolicy<E> {
    private static String COLLIDING_DATE_FORMAT_URL = "https://logback.qos.ch/codes.html#rfa_collision_in_dateFormat";
    protected TimeBasedRollingPolicy<E> tbrp;
    protected ArchiveRemover archiveRemover = null;
    protected String elapsedPeriodsFileName;
    protected RollingCalendar rc;
    protected long artificialCurrentTime = -1L;
    protected AtomicLong atomicNextCheck = new AtomicLong(0L);
    protected Instant dateInCurrentPeriod = null;
    protected boolean started = false;
    protected boolean errorFree = true;

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        File file;
        DateTokenConverter<Object> dateTokenConverter = this.tbrp.fileNamePattern.getPrimaryDateTokenConverter();
        if (dateTokenConverter == null) {
            throw new IllegalStateException("FileNamePattern [" + this.tbrp.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        if (dateTokenConverter.getZoneId() != null) {
            TimeZone timeZone = TimeZone.getTimeZone(dateTokenConverter.getZoneId());
            this.rc = new RollingCalendar(dateTokenConverter.getDatePattern(), timeZone, Locale.getDefault());
        } else {
            this.rc = new RollingCalendar(dateTokenConverter.getDatePattern());
        }
        this.addInfo("The date pattern is '" + dateTokenConverter.getDatePattern() + "' from file name pattern '" + this.tbrp.fileNamePattern.getPattern() + "'.");
        this.rc.printPeriodicity(this);
        if (!this.rc.isCollisionFree()) {
            this.addError("The date format in FileNamePattern will result in collisions in the names of archived log files.");
            this.addError("For more information, please visit " + COLLIDING_DATE_FORMAT_URL);
            this.withErrors();
            return;
        }
        long l2 = this.getCurrentTime();
        this.setDateInCurrentPeriod(l2);
        if (this.tbrp.getParentsRawFileProperty() != null && (file = new File(this.tbrp.getParentsRawFileProperty())).exists() && file.canRead()) {
            l2 = file.lastModified();
            this.setDateInCurrentPeriod(l2);
        }
        TimeBasedFileNamingAndTriggeringPolicyBase timeBasedFileNamingAndTriggeringPolicyBase = this;
        timeBasedFileNamingAndTriggeringPolicyBase.addInfo("Setting initial period to " + String.valueOf(timeBasedFileNamingAndTriggeringPolicyBase.dateInCurrentPeriod));
        long l3 = this.computeNextCheck(l2);
        this.atomicNextCheck.set(l3);
    }

    @Override
    public void stop() {
        this.started = false;
    }

    protected long computeNextCheck(long l2) {
        return this.rc.getNextTriggeringDate(Instant.ofEpochMilli(l2)).toEpochMilli();
    }

    @Override
    public String getElapsedPeriodsFileName() {
        return this.elapsedPeriodsFileName;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convert(this.dateInCurrentPeriod);
    }

    protected void setDateInCurrentPeriod(long l2) {
        this.dateInCurrentPeriod = Instant.ofEpochMilli(l2);
    }

    @Override
    public void setCurrentTime(long l2) {
        this.artificialCurrentTime = l2;
    }

    @Override
    public long getCurrentTime() {
        if (this.artificialCurrentTime >= 0L) {
            return this.artificialCurrentTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public void setTimeBasedRollingPolicy(TimeBasedRollingPolicy<E> timeBasedRollingPolicy) {
        this.tbrp = timeBasedRollingPolicy;
    }

    @Override
    public ArchiveRemover getArchiveRemover() {
        return this.archiveRemover;
    }

    protected void withErrors() {
        this.errorFree = false;
    }

    protected boolean isErrorFree() {
        return this.errorFree;
    }
}

