/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.CompressionStrategy;
import ch.qos.logback.core.rolling.helper.Compressor$CompressionRunnable;
import ch.qos.logback.core.rolling.helper.GZCompressionStrategy;
import ch.qos.logback.core.rolling.helper.ZipCompressionStrategy;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.concurrent.Future;

public class Compressor
extends ContextAwareBase {
    public static final String COULD_NOT_OBTAIN_COMPRESSION_STRATEGY_MESSAGE = "Could not obtain compression strategy";
    public static final String XZ_COMPRESSION_STRATEGY_CLASS_NAME = "ch.qos.logback.core.rolling.helper.XZCompressionStrategy";
    final CompressionMode compressionMode;
    static final int BUFFER_SIZE = 8192;

    public Compressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public void compress(String string, String string2, String string3) {
        Compressor compressor = this;
        CompressionStrategy compressionStrategy = compressor.makeCompressionStrategy(compressor.compressionMode);
        if (compressionStrategy == null) {
            this.addWarn(COULD_NOT_OBTAIN_COMPRESSION_STRATEGY_MESSAGE);
            return;
        }
        compressionStrategy.setContext(this.getContext());
        compressionStrategy.compress(string, string2, string3);
    }

    CompressionStrategy makeCompressionStrategy(CompressionMode compressionMode) {
        switch (compressionMode) {
            case GZ: {
                return new GZCompressionStrategy();
            }
            case ZIP: {
                return new ZipCompressionStrategy();
            }
            case XZ: {
                return this.dynamicInstantiation(XZ_COMPRESSION_STRATEGY_CLASS_NAME);
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
        return null;
    }

    private CompressionStrategy dynamicInstantiation(String string) {
        try {
            return (CompressionStrategy)OptionHelper.instantiateByClassName(string, CompressionStrategy.class, this.getContext());
        }
        catch (DynamicClassLoadingException | IncompatibleClassException exception) {
            this.addError("Could not instantiate " + string, exception);
            return null;
        }
    }

    public static String computeFileNameStrWithoutCompSuffix(String string, CompressionMode compressionMode) {
        int n2 = string.length();
        switch (compressionMode) {
            case GZ: {
                if (string.endsWith(".gz")) {
                    return string.substring(0, n2 - 3);
                }
                return string;
            }
            case ZIP: {
                if (string.endsWith(".zip")) {
                    return string.substring(0, n2 - 4);
                }
                return string;
            }
            case XZ: {
                if (string.endsWith(".xz")) {
                    return string.substring(0, n2 - 3);
                }
                return string;
            }
            case NONE: {
                return string;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Future<?> asyncCompress(String future, String object, String string) throws RolloverFailure {
        future = new Compressor$CompressionRunnable(this, (String)((Object)future), (String)object, string);
        object = this.context.getExecutorService();
        future = object.submit((Runnable)((Object)future));
        return future;
    }
}

