/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.DatePatternToRegexUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

public class DateTokenConverter<E>
extends DynamicConverter<E>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "d";
    public static final String AUXILIARY_TOKEN = "AUX";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private String datePattern;
    private ZoneId zoneId;
    private CachingDateFormatter cdf;
    private boolean primary = true;

    @Override
    public void start() {
        List<String> list;
        this.datePattern = this.getFirstOption();
        if (this.datePattern == null) {
            this.datePattern = DEFAULT_DATE_PATTERN;
        }
        if ((list = this.getOptionList()) != null) {
            for (int i2 = 1; i2 < list.size(); ++i2) {
                String string = list.get(i2);
                if (AUXILIARY_TOKEN.equalsIgnoreCase(string)) {
                    this.primary = false;
                    continue;
                }
                this.zoneId = ZoneId.of(string);
            }
        }
        this.cdf = new CachingDateFormatter(this.datePattern, this.zoneId);
    }

    @Override
    public String convert(Date date) {
        return this.cdf.format(date.getTime());
    }

    @Override
    public String convert(Instant instant) {
        return this.cdf.format(instant.toEpochMilli());
    }

    @Override
    public String convert(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (object instanceof Date) {
            return this.convert((Date)object);
        }
        if (object instanceof Instant) {
            return this.convert((Instant)object);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(object) + " of type" + object.getClass().getName());
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Override
    public boolean isApplicable(Object object) {
        if (object instanceof Date) {
            return true;
        }
        return object instanceof Instant;
    }

    public String toRegex() {
        DatePatternToRegexUtil datePatternToRegexUtil = new DatePatternToRegexUtil(this.datePattern);
        return datePatternToRegexUtil.toRegex();
    }

    public boolean isPrimary() {
        return this.primary;
    }
}

