/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionStrategyBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;

public class GZCompressionStrategy
extends CompressionStrategyBase {
    @Override
    public void compress(String string, String object, String object2) {
        File file;
        object2 = new File(string);
        if (!((File)object2).exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (!((String)object).endsWith(".gz")) {
            object = (String)object + ".gz";
        }
        if ((file = new File((String)object)).exists()) {
            this.addWarn("The target compressed file named [" + (String)object + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + String.valueOf(object2) + "] as [" + String.valueOf(file) + "]");
        this.createMissingTargetDirsIfNecessary(file);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
             GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream((String)object));){
            int n2;
            byte[] byArray = new byte[8192];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                gZIPOutputStream.write(byArray, 0, n2);
            }
            this.addInfo("Done GZ compressing [" + String.valueOf(object2) + "] as [" + String.valueOf(file) + "]");
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + (String)object + "].", this, exception));
        }
        if (!((File)object2).delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
        }
    }
}

