/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "https://logback.qos.ch/codes.html#renamingError";

    public void rename(String string, String string2) throws RolloverFailure {
        if (string.equals(string2)) {
            this.addWarn("Source and target files are the same [" + string + "]. Skipping.");
            return;
        }
        Comparable<File> comparable = new File(string);
        if (comparable.exists()) {
            File file = new File(string2);
            this.createMissingTargetDirsIfNecessary(file);
            this.addInfo("Renaming file [" + String.valueOf(comparable) + "] to [" + String.valueOf(file) + "]");
            boolean bl2 = comparable.renameTo(file);
            if (!bl2) {
                this.addWarn("Failed to rename file [" + String.valueOf(comparable) + "] as [" + String.valueOf(file) + "].");
                comparable = this.areOnDifferentVolumes((File)comparable, file);
                if (Boolean.TRUE.equals(comparable)) {
                    this.addWarn("Detected different file systems for source [" + string + "] and target [" + string2 + "]. Attempting rename by copying.");
                    this.renameByCopying(string, string2);
                    return;
                }
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
            return;
        }
        throw new RolloverFailure("File [" + string + "] does not exist.");
    }

    Boolean areOnDifferentVolumes(File file, File file2) throws RolloverFailure {
        if (!EnvUtil.isJDK7OrHigher()) {
            return Boolean.FALSE;
        }
        File file3 = file2.getAbsoluteFile().getParentFile();
        if (file3 == null) {
            this.addWarn("Parent of target file [" + String.valueOf(file2) + "] is null");
            return null;
        }
        if (!file3.exists()) {
            this.addWarn("Parent of target file [" + String.valueOf(file2) + "] does not exist");
            return null;
        }
        try {
            boolean bl2 = FileStoreUtil.areOnSameFileStore(file, file3);
            return !bl2;
        }
        catch (RolloverFailure rolloverFailure) {
            this.addWarn("Error while checking file store equality", rolloverFailure);
            return null;
        }
    }

    public void renameByCopying(String string, String object) throws RolloverFailure {
        FileUtil fileUtil = new FileUtil(this.getContext());
        fileUtil.copy(string, (String)object);
        object = new File(string);
        if (!((File)object).delete()) {
            this.addWarn("Could not delete " + string);
        }
    }

    void createMissingTargetDirsIfNecessary(File file) throws RolloverFailure {
        boolean bl2 = FileUtil.createMissingParentDirectories(file);
        if (!bl2) {
            throw new RolloverFailure("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

