/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionStrategyBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.OutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class XZCompressionStrategy
extends CompressionStrategyBase {
    @Override
    public void compress(String string, String object, String object2) {
        Object object3;
        object2 = new File(string);
        if (!((File)object2).exists()) {
            this.addWarn("The file to compress named [" + string + "] does not exist.");
            return;
        }
        if (!((String)object).endsWith(".xz")) {
            object = (String)object + ".xz";
        }
        if (((File)(object3 = new File((String)object))).exists()) {
            this.addWarn("The target compressed file named [" + (String)object + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("XZ compressing [" + String.valueOf(object2) + "] as [" + String.valueOf(object3) + "]");
        this.createMissingTargetDirsIfNecessary((File)object3);
        try {
            object3 = new BufferedInputStream(new FileInputStream(string));
            try (XZOutputStream xZOutputStream = new XZOutputStream((OutputStream)new FileOutputStream((String)object), (FilterOptions)new LZMA2Options());){
                int n2;
                byte[] byArray = new byte[8192];
                while ((n2 = ((FilterInputStream)object3).read(byArray)) != -1) {
                    xZOutputStream.write(byArray, 0, n2);
                }
            }
            finally {
                ((BufferedInputStream)object3).close();
            }
        }
        catch (Exception exception) {
            this.addError("Error occurred while compressing [" + string + "] into [" + (String)object + "].", exception);
        }
        if (!((File)object2).delete()) {
            this.addWarn("Could not delete [" + string + "].");
        }
    }
}

