/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.CompressionStrategyBase;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCompressionStrategy
extends CompressionStrategyBase {
    static final int BUFFER_SIZE = 8192;

    @Override
    public void compress(String string, String object, String object2) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (object2 == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!((String)object).endsWith(".zip")) {
            object = (String)object + ".zip";
        }
        if ((file = new File((String)object)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + (String)object + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        this.createMissingTargetDirsIfNecessary(file);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
             ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream((String)object));){
            int n2;
            object2 = this.computeZipEntry((String)object2);
            zipOutputStream.putNextEntry((ZipEntry)object2);
            byte[] byArray = new byte[8192];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n2);
            }
            this.addInfo("Done ZIP compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + (String)object + "].", this, exception));
        }
        if (!file2.delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
        }
    }

    ZipEntry computeZipEntry(String string) {
        string = Compressor.computeFileNameStrWithoutCompSuffix(string, CompressionMode.ZIP);
        return new ZipEntry(string);
    }
}

