/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SiftModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.sift.AppenderFactoryUsingSiftModel;
import ch.qos.logback.core.sift.SiftingAppenderBase;

public class SiftModelHandler
extends ModelHandlerBase {
    static final String ONE_AND_ONLY_ONE_URL = "https://logback.qos.ch/codes.html#1andOnly1";

    public SiftModelHandler(Context context) {
        super(context);
    }

    public static SiftModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new SiftModelHandler(context);
    }

    protected Class<SiftModel> getSupportedModelClass() {
        return SiftModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext object, Model model) throws ModelHandlerException {
        model = (SiftModel)model;
        model.markAsSkipped();
        long l2 = this.computeAppenderModelCount((SiftModel)model);
        if (l2 == 0L) {
            String string = "No nested appenders found within the <sift> element in SiftingAppender.";
            this.addError(string);
            return;
        }
        if (l2 > 1L) {
            String string = "Only and only one appender can be nested the <sift> element in SiftingAppender. See also https://logback.qos.ch/codes.html#1andOnly1";
            this.addError(string);
            return;
        }
        Object object2 = ((ModelInterpretationContext)object).peekObject();
        if (object2 instanceof SiftingAppenderBase) {
            object2 = (SiftingAppenderBase)object2;
            String string = ((SiftingAppenderBase)object2).getDiscriminatorKey();
            object = new AppenderFactoryUsingSiftModel((ModelInterpretationContext)object, model, string);
            ((SiftingAppenderBase)object2).setAppenderFactory(object);
            return;
        }
        this.addError("Unexpected object " + String.valueOf(object2));
    }

    private long computeAppenderModelCount(SiftModel object) {
        object = ((Model)object).getSubModels().stream();
        long l2 = object.filter(model -> model instanceof AppenderModel).count();
        return l2;
    }
}

