/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Token$Type;
import ch.qos.logback.core.subst.Tokenizer$TokenizerState;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    final String pattern;
    final int patternLength;
    Tokenizer$TokenizerState state = Tokenizer$TokenizerState.LITERAL_STATE;
    int pointer = 0;

    public Tokenizer(String string) {
        this.pattern = string;
        this.patternLength = string.length();
    }

    List<Token> tokenize() throws ScanException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state.ordinal()) {
                case 0: {
                    this.handleLiteralState(c2, arrayList, stringBuilder);
                    break;
                }
                case 1: {
                    this.handleStartState(c2, arrayList, stringBuilder);
                    break;
                }
                case 2: {
                    this.handleDefaultValueState(c2, arrayList, stringBuilder);
                }
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.addLiteralToken(arrayList, stringBuilder);
                break;
            }
            case 2: {
                stringBuilder.append(':');
                this.addLiteralToken(arrayList, stringBuilder);
                break;
            }
            case 1: {
                stringBuilder.append('$');
                this.addLiteralToken(arrayList, stringBuilder);
            }
        }
        return arrayList;
    }

    private void handleDefaultValueState(char c2, List<Token> list, StringBuilder stringBuilder) {
        switch (c2) {
            case '-': {
                list.add(Token.DEFAULT_SEP_TOKEN);
                this.state = Tokenizer$TokenizerState.LITERAL_STATE;
                return;
            }
            case '$': {
                stringBuilder.append(':');
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                this.state = Tokenizer$TokenizerState.START_STATE;
                return;
            }
            case '{': {
                stringBuilder.append(':');
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                list.add(Token.CURLY_LEFT_TOKEN);
                this.state = Tokenizer$TokenizerState.LITERAL_STATE;
                return;
            }
        }
        stringBuilder.append(':').append(c2);
        this.state = Tokenizer$TokenizerState.LITERAL_STATE;
    }

    private void handleStartState(char c2, List<Token> list, StringBuilder stringBuilder) {
        if (c2 == '{') {
            list.add(Token.START_TOKEN);
        } else {
            stringBuilder.append('$').append(c2);
        }
        this.state = Tokenizer$TokenizerState.LITERAL_STATE;
    }

    private void handleLiteralState(char c2, List<Token> list, StringBuilder stringBuilder) {
        switch (c2) {
            case '$': {
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                this.state = Tokenizer$TokenizerState.START_STATE;
                return;
            }
            case ':': {
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                this.state = Tokenizer$TokenizerState.DEFAULT_VAL_STATE;
                return;
            }
            case '{': {
                this.addLiteralToken(list, stringBuilder);
                list.add(Token.CURLY_LEFT_TOKEN);
                stringBuilder.setLength(0);
                return;
            }
            case '}': {
                this.addLiteralToken(list, stringBuilder);
                list.add(Token.CURLY_RIGHT_TOKEN);
                stringBuilder.setLength(0);
                return;
            }
        }
        stringBuilder.append(c2);
    }

    private void addLiteralToken(List<Token> list, StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        list.add(new Token(Token$Type.LITERAL, stringBuilder.toString()));
    }
}

