/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileToBufferUtil {
    public static void readIntoList(File file, List<String> list) throws IOException {
        if (file.getName().endsWith(".gz")) {
            FileToBufferUtil.gzFileReadIntoList(file, list);
            return;
        }
        if (file.getName().endsWith(".zip")) {
            FileToBufferUtil.zipFileReadIntoList(file, list);
            return;
        }
        FileToBufferUtil.regularReadIntoList(file, list);
    }

    private static void zipFileReadIntoList(File object, List<String> list) throws IOException {
        System.out.println("Reading zip file [" + String.valueOf(object) + "]");
        object = new ZipFile((File)object);
        try {
            Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
            ZipEntry zipEntry = enumeration.nextElement();
            FileToBufferUtil.readInputStream(((ZipFile)object).getInputStream(zipEntry), list);
            return;
        }
        finally {
            ((ZipFile)object).close();
        }
    }

    static void readInputStream(InputStream closeable, List<String> list) throws IOException {
        String string;
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
        while ((string = ((BufferedReader)closeable).readLine()) != null) {
            list.add(string);
        }
        ((BufferedReader)closeable).close();
    }

    public static void regularReadIntoList(File object, List<String> list) throws IOException {
        String string;
        object = new FileInputStream((File)object);
        object = new BufferedReader(new InputStreamReader((InputStream)object));
        while ((string = ((BufferedReader)object).readLine()) != null) {
            list.add(string);
        }
        ((BufferedReader)object).close();
    }

    public static void gzFileReadIntoList(File object, List<String> list) throws IOException {
        object = new FileInputStream((File)object);
        object = new GZIPInputStream((InputStream)object);
        FileToBufferUtil.readInputStream((InputStream)object, list);
    }
}

