/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class DirectJson {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final byte QUOTE = 34;
    private static final byte ENTRY_SEP = 58;
    private static final byte KV_SEP = 44;
    private static final byte DOT = 46;
    private static final byte OPEN_OBJ = 123;
    private static final byte CLOSE_OBJ = 125;
    private static final byte OPEN_ARR = 91;
    private static final byte CLOSE_ARR = 93;
    private static final byte[] NEWLINE = new byte[]{92, 110};
    private static final byte[] ESCAPE = new byte[]{92, 92};
    private static final byte[] LINEBREAK = new byte[]{92, 114};
    private static final byte[] TAB = new byte[]{92, 116};
    private static final byte[] TRUE = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE = new byte[]{102, 97, 108, 115, 101};
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};
    private ByteBuffer buffer = ByteBuffer.allocateDirect(1024);

    public final void openObject() {
        this.buffer.put((byte)123);
    }

    public final void openArray() {
        this.buffer.put((byte)91);
    }

    public final void openObject(String string) {
        this.writeString(string);
        this.writeEntrySep();
        this.buffer.put((byte)123);
    }

    public final void openArray(String string) {
        this.writeString(string);
        this.writeEntrySep();
        this.buffer.put((byte)91);
    }

    public final void closeObject() {
        int n2 = this.buffer.position() - 1;
        if (44 == this.buffer.get(n2)) {
            this.buffer.put(n2, (byte)125);
            return;
        }
        this.buffer.put((byte)125);
    }

    public final void closeArray() {
        int n2 = this.buffer.position() - 1;
        if (44 == this.buffer.get(n2)) {
            this.buffer.put(n2, (byte)93);
            return;
        }
        this.buffer.put((byte)93);
    }

    public final void writeRaw(String string) {
        block6: for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.codePointAt(i2);
            switch (n2) {
                case 92: {
                    this.buffer.put(ESCAPE);
                    continue block6;
                }
                case 10: {
                    this.buffer.put(NEWLINE);
                    continue block6;
                }
                case 13: {
                    this.buffer.put(LINEBREAK);
                    continue block6;
                }
                case 9: {
                    this.buffer.put(TAB);
                    continue block6;
                }
                default: {
                    if (n2 >= 128 && n2 <= 0x10FFFF) {
                        this.buffer.put(String.valueOf(string.charAt(i2)).getBytes());
                        continue block6;
                    }
                    if (n2 <= 31) continue block6;
                    this.buffer.put((byte)n2);
                }
            }
        }
    }

    public final void writeRaw(char c2) {
        this.buffer.put((byte)c2);
    }

    public final void writeRaw(byte[] byArray) {
        this.buffer.put(byArray);
    }

    public final void writeQuote() {
        this.buffer.put((byte)34);
    }

    public final void writeString(String string) {
        this.checkSpace(string.length() + 3);
        this.buffer.put((byte)34);
        this.writeRaw(string);
        this.buffer.put((byte)34);
        this.buffer.put((byte)44);
    }

    public final void writeSep() {
        this.buffer.put((byte)44);
    }

    public final void writeNumberRaw(long l2) {
        int n2 = this.buffer.position();
        int n3 = (int)Math.log10(l2) + 1;
        long l3 = l2;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            byte by2 = (byte)(l3 % 10L);
            l3 /= 10L;
            by2 = (byte)(by2 + 48);
            this.buffer.put(n2 + i2, by2);
        }
        this.buffer.position(n2 + n3);
    }

    public final void writeNumber(long l2) {
        int n2 = this.buffer.position();
        int n3 = l2 == 0L ? 1 : (int)Math.log10(l2) + 1;
        long l3 = l2;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            byte by2 = (byte)(l3 % 10L);
            l3 /= 10L;
            by2 = (byte)(by2 + 48);
            this.buffer.put(n2 + i2, by2);
        }
        this.buffer.position(n2 + n3);
        this.buffer.put((byte)44);
    }

    public final void writeNumber(double d2) {
        int n2;
        int n3 = this.buffer.position();
        long l2 = (long)d2;
        int n4 = (int)Math.log10(l2) + 1;
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            n2 = (int)(l2 % 10L);
            l2 /= 10L;
            n2 = (byte)(n2 + 48);
            this.buffer.put(n3 + i2, (byte)n2);
        }
        this.buffer.position(n3 + n4);
        this.buffer.put((byte)46);
        n3 = this.buffer.position();
        BigDecimal bigDecimal = BigDecimal.valueOf(d2).remainder(BigDecimal.ONE);
        n2 = 0;
        while (!bigDecimal.equals(BigDecimal.ZERO)) {
            bigDecimal = bigDecimal.movePointRight(1);
            byte by2 = (byte)(bigDecimal.intValue() + 48);
            bigDecimal = bigDecimal.remainder(BigDecimal.ONE);
            ++n2;
            this.buffer.put(by2);
        }
        this.buffer.position(n3 + n2);
        this.buffer.put((byte)44);
    }

    public final void writeEntrySep() {
        this.buffer.put(this.buffer.position() - 1, (byte)58);
    }

    public final void writeStringValue(String string, String string2) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeString(string2);
    }

    public final void writeNumberValue(String string, long l2) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeNumber(l2);
    }

    public final void writeNumberValue(String string, double d2) {
        this.writeString(string);
        this.writeEntrySep();
        this.writeNumber(d2);
    }

    public final void writeBoolean(boolean bl2) {
        this.buffer.put(bl2 ? TRUE : FALSE);
        this.buffer.put((byte)44);
    }

    public final void writeNull() {
        this.buffer.put(NULL);
        this.buffer.put((byte)44);
    }

    public final void checkSpace(int n2) {
        if (this.buffer.position() + n2 >= this.buffer.capacity()) {
            n2 = this.buffer.capacity() + n2 << 1;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            this.buffer.flip();
            byteBuffer.put(this.buffer);
            this.buffer = byteBuffer;
        }
    }

    public final byte[] flush() {
        byte[] byArray = new byte[this.buffer.position()];
        this.buffer.flip();
        this.buffer.get(byArray);
        this.buffer.clear();
        return byArray;
    }
}

