/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Loader;
import java.lang.module.ModuleDescriptor;
import java.util.Optional;

public class EnvUtil {
    private EnvUtil() {
    }

    public static String logbackVersion() {
        Object object = EnvUtil.getVersionOfLogbackCoreByModule();
        if (object != null) {
            return object;
        }
        object = EnvUtil.class.getPackage();
        if (object == null) {
            return null;
        }
        return ((Package)object).getImplementationVersion();
    }

    private static String getVersionOfLogbackCoreByModule() {
        Object object = EnvUtil.class.getModule();
        if (object == null) {
            return null;
        }
        if ((object = ((Module)object).getDescriptor()) == null) {
            return null;
        }
        object = ((ModuleDescriptor)object).rawVersion();
        return ((Optional)object).orElse(null);
    }

    public static int getJDKVersion(String object) {
        int n2 = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = object[i2];
            if (Character.isDigit((char)object2)) {
                n2 = n2 * 10 + (object2 - 48);
                continue;
            }
            if (n2 != 1) break;
            n2 = 0;
        }
        return n2;
    }

    private static boolean isJDK_N_OrHigher(int n2) {
        String string = System.getProperty("java.version", "");
        if (string.isEmpty()) {
            return false;
        }
        int n3 = EnvUtil.getJDKVersion(string);
        return n3 > 0 && n2 <= n3;
    }

    public static boolean isJDK5() {
        return EnvUtil.isJDK_N_OrHigher(5);
    }

    public static boolean isJDK6OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(6);
    }

    public static boolean isJDK7OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(7);
    }

    public static boolean isJDK16OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(16);
    }

    public static boolean isJDK18OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(18);
    }

    public static boolean isJDK21OrHigher() {
        return EnvUtil.isJDK_N_OrHigher(21);
    }

    public static boolean isJaninoAvailable() {
        Object object = EnvUtil.class.getClassLoader();
        try {
            object = ((ClassLoader)object).loadClass("org.codehaus.janino.ScriptEvaluator");
            return object != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isMacOs() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().contains("mac");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    public static boolean isClassAvailable(Class clazz, String string) {
        clazz = Loader.getClassLoaderOfClass(clazz);
        try {
            clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

